/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.blockentity;

import greekfantasy.client.blockentity.CerberusHeadBlockEntityRenderer;
import greekfantasy.client.blockentity.GiganteHeadBlockEntityRenderer;
import greekfantasy.client.blockentity.OrthusHeadBlockEntityRenderer;
import greekfantasy.client.entity.SpearRenderer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;

public class BlockEntityRendererProvider {
    private static BlockEntityWithoutLevelRenderer orthusHead;
    private static BlockEntityWithoutLevelRenderer cerberusHead;
    private static BlockEntityWithoutLevelRenderer giganteHead;
    private static final Map<ResourceLocation, BlockEntityWithoutLevelRenderer> spearMap;

    public static BlockEntityWithoutLevelRenderer getOrthusHead() {
        if (orthusHead == null) {
            BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            EntityModelSet entityModelSet = Minecraft.getInstance().getEntityModels();
            orthusHead = new OrthusHeadBlockEntityRenderer.OrthusHeadItemStackRenderer(dispatcher, entityModelSet);
        }
        return orthusHead;
    }

    public static BlockEntityWithoutLevelRenderer getGiganteHead() {
        if (giganteHead == null) {
            BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            EntityModelSet entityModelSet = Minecraft.getInstance().getEntityModels();
            giganteHead = new GiganteHeadBlockEntityRenderer.GiganteHeadItemStackRenderer(dispatcher, entityModelSet);
        }
        return giganteHead;
    }

    public static BlockEntityWithoutLevelRenderer getCerberusHead() {
        if (cerberusHead == null) {
            BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            EntityModelSet entityModelSet = Minecraft.getInstance().getEntityModels();
            cerberusHead = new CerberusHeadBlockEntityRenderer.CerberusHeadItemStackRenderer(dispatcher, entityModelSet);
        }
        return cerberusHead;
    }

    public static BlockEntityWithoutLevelRenderer getSpear(ResourceLocation key) {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Attempted to access BlockEntityRendererProvider on the server, aborting.");
        }
        if (!spearMap.containsKey(key)) {
            BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            EntityModelSet entityModelSet = Minecraft.getInstance().getEntityModels();
            spearMap.put(key, new SpearRenderer.SpearItemStackRenderer(dispatcher, entityModelSet, key));
        }
        return spearMap.get(key);
    }

    static {
        spearMap = new HashMap<ResourceLocation, BlockEntityWithoutLevelRenderer>();
    }
}

