/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.blockentity.MobHeadBlockEntity;
import greekfantasy.client.blockentity.MobHeadBlockEntityRenderer;
import greekfantasy.client.blockentity.model.GiganteHeadModel;
import greekfantasy.client.entity.GiganteRenderer;
import greekfantasy.client.entity.model.GiganteModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GiganteHeadBlockEntityRenderer
extends MobHeadBlockEntityRenderer {
    public GiganteHeadBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context, new GiganteHeadModel(context.getModelSet().bakeLayer(GiganteHeadModel.GIGANTE_HEAD_MODEL_RESOURCE)));
    }

    @Override
    public ResourceLocation getTexture() {
        return GiganteRenderer.TEXTURE;
    }

    @Override
    public float getScale() {
        return 1.9f;
    }

    @Override
    public void applyRotations(PoseStack poseStack, boolean isOnWall) {
        poseStack.translate(0.6, 1.0, 0.6);
    }

    public boolean shouldRenderOffScreen(MobHeadBlockEntity blockEntity) {
        return true;
    }

    public static class GiganteHeadItemStackRenderer
    extends BlockEntityWithoutLevelRenderer {
        private static final ResourceLocation TEXTURE = GiganteRenderer.TEXTURE;
        private final EntityModelSet entityModelSet;
        private GiganteHeadModel model;

        public GiganteHeadItemStackRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet entityModelSet) {
            super(dispatcher, entityModelSet);
            this.entityModelSet = entityModelSet;
            this.model = new GiganteHeadModel(this.entityModelSet.bakeLayer(GiganteModel.GIGANTE_MODEL_RESOURCE));
        }

        public void onResourceManagerReload(ResourceManager resourceManager) {
            this.model = new GiganteHeadModel(this.entityModelSet.bakeLayer(GiganteModel.GIGANTE_MODEL_RESOURCE));
        }

        public void renderByItem(ItemStack item, ItemDisplayContext transform, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.25f, 0.0f);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            VertexConsumer vertexBuilder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)this.model.renderType(TEXTURE), (boolean)false, (boolean)item.hasFoil());
            this.model.renderToBuffer(poseStack, vertexBuilder, combinedLightIn, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

