/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import greekfantasy.block.MobHeadBlock;
import greekfantasy.blockentity.MobHeadBlockEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class MobHeadBlockEntityRenderer
implements BlockEntityRenderer<MobHeadBlockEntity> {
    protected final BlockEntityRendererProvider.Context context;
    protected final Model model;

    public MobHeadBlockEntityRenderer(BlockEntityRendererProvider.Context context, Model model) {
        this.context = context;
        this.model = model;
    }

    public void render(MobHeadBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float rotation = ((Direction)blockEntity.getBlockState().getValue((Property)MobHeadBlock.FACING)).toYRot();
        ResourceLocation texture = this.getTexture();
        float scale = this.getScale();
        poseStack.pushPose();
        poseStack.translate(0.5, 1.0, 0.5);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        this.applyRotations(poseStack, blockEntity.onWall());
        poseStack.scale(scale, scale, scale);
        VertexConsumer vertexBuilder = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)texture));
        this.model.renderToBuffer(poseStack, vertexBuilder, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public abstract ResourceLocation getTexture();

    public abstract float getScale();

    public abstract void applyRotations(PoseStack var1, boolean var2);
}

