/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.blockentity.MobHeadBlockEntity;
import greekfantasy.client.blockentity.MobHeadBlockEntityRenderer;
import greekfantasy.client.blockentity.model.OrthusHeadModel;
import greekfantasy.client.entity.OrthusRenderer;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class OrthusHeadBlockEntityRenderer
extends MobHeadBlockEntityRenderer {
    public OrthusHeadBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context, new OrthusHeadModel(context.getModelSet().bakeLayer(OrthusHeadModel.ORTHUS_HEAD_MODEL_RESOURCE)));
    }

    @Override
    public ResourceLocation getTexture() {
        return OrthusRenderer.TEXTURE;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    @Override
    public void applyRotations(PoseStack poseStack, boolean isOnWall) {
        if (isOnWall) {
            poseStack.translate(0.0f, 0.5f, 0.375f);
        } else {
            poseStack.translate(0.0, 0.8125, 0.0);
        }
    }

    public boolean shouldRenderOffScreen(MobHeadBlockEntity blockEntity) {
        return true;
    }

    public static class OrthusHeadItemStackRenderer
    extends BlockEntityWithoutLevelRenderer {
        private static final ResourceLocation TEXTURE = OrthusRenderer.TEXTURE;
        private final EntityModelSet entityModelSet;
        private OrthusHeadModel model;

        public OrthusHeadItemStackRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet entityModelSet) {
            super(dispatcher, entityModelSet);
            this.entityModelSet = entityModelSet;
            this.model = new OrthusHeadModel(this.entityModelSet.bakeLayer(OrthusHeadModel.ORTHUS_HEAD_MODEL_RESOURCE));
        }

        public void onResourceManagerReload(ResourceManager resourceManager) {
            this.model = new OrthusHeadModel(this.entityModelSet.bakeLayer(OrthusHeadModel.ORTHUS_HEAD_MODEL_RESOURCE));
        }

        public void renderByItem(ItemStack item, ItemDisplayContext transform, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, -0.125f);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            VertexConsumer vertexBuilder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)this.model.renderType(TEXTURE), (boolean)false, (boolean)item.hasFoil());
            this.model.renderToBuffer(poseStack, vertexBuilder, combinedLightIn, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

