/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import greekfantasy.block.VaseBlock;
import greekfantasy.blockentity.VaseBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.joml.Matrix4f;

public class VaseBlockEntityRenderer
implements BlockEntityRenderer<VaseBlockEntity> {
    protected final BlockEntityRendererProvider.Context context;

    public VaseBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(VaseBlockEntity vaseBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack itemstack = vaseBlockEntity.getItem(0);
        if (!itemstack.isEmpty()) {
            float scale = 0.315f;
            float rotation = ((Direction)vaseBlockEntity.getBlockState().getValue((Property)VaseBlock.FACING)).toYRot();
            poseStack.pushPose();
            poseStack.translate(0.5, 0.7, 0.5);
            poseStack.mulPose(Axis.YN.rotationDegrees(rotation));
            poseStack.scale(0.315f, 0.315f, 0.315f);
            Minecraft.getInstance().getItemRenderer().renderStatic(itemstack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, null, 0);
            poseStack.popPose();
            if (vaseBlockEntity.hasCustomName() && this.shouldRenderName(vaseBlockEntity)) {
                this.renderNameTag(vaseBlockEntity, vaseBlockEntity.getCustomName(), poseStack, bufferSource, packedLight);
            }
        }
    }

    protected boolean shouldRenderName(BlockEntity blockEntity) {
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher renderManager = mc.getEntityRenderDispatcher();
        Vec3 pos = Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos());
        double distance = 6.0;
        if (renderManager.distanceToSqr(pos.x, pos.y, pos.z) < 36.0 && mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockPos = new BlockPos((int)mc.hitResult.getLocation().x, (int)mc.hitResult.getLocation().y, (int)mc.hitResult.getLocation().z);
            BlockState blockState = blockEntity.getLevel().getBlockState(blockPos);
            return blockPos.equals((Object)blockEntity.getBlockPos()) && blockState.is(blockEntity.getBlockState().getBlock());
        }
        return false;
    }

    protected void renderNameTag(VaseBlockEntity blockEntity, Component name, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        float height = (float)blockEntity.getBlockState().getShape((BlockGetter)blockEntity.getLevel(), blockEntity.getBlockPos(), CollisionContext.empty()).max(Direction.Axis.Y);
        float f = height + 0.5f;
        poseStack.pushPose();
        poseStack.translate(0.5, (double)f, 0.5);
        poseStack.mulPose(this.context.getBlockEntityRenderDispatcher().camera.rotation());
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f1 = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        Font font = this.context.getFont();
        float f2 = -font.width((FormattedText)name) / 2;
        font.drawInBatch(name, f2, 0.0f, 0x20FFFFFF, false, matrix4f, multiBufferSource, Font.DisplayMode.NORMAL, j, packedLight);
        font.drawInBatch(name, f2, 0.0f, -1, false, matrix4f, multiBufferSource, Font.DisplayMode.SEE_THROUGH, 0, packedLight);
        poseStack.popPose();
    }
}

