/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import greekfantasy.client.entity.layer.CerberusEyesLayer;
import greekfantasy.client.entity.model.CerberusModel;
import greekfantasy.entity.boss.Cerberus;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;

public class CerberusRenderer<T extends Cerberus>
extends MobRenderer<T, CerberusModel<T>> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/cerberus/cerberus.png");
    public static final float SCALE = 1.9f;

    public CerberusRenderer(EntityRendererProvider.Context context) {
        super(context, new CerberusModel(context.bakeLayer(CerberusModel.CERBERUS_MODEL_RESOURCE)), 1.0f);
        this.addLayer((RenderLayer)new CerberusEyesLayer(this));
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }

    protected void scale(T entity, PoseStack poseStack, float partialTick) {
        if (((Cerberus)((Object)entity)).isSpawning()) {
            float height = 2.4f;
            float translateY = 2.4f * ((Cerberus)((Object)entity)).getSpawnPercent(partialTick) - 2.4f;
            poseStack.translate(0.0f, -translateY, 0.0f);
        }
        poseStack.scale(1.9f, 1.9f, 1.9f);
    }

    protected boolean isShaking(T entity) {
        return ((Cerberus)((Object)entity)).isSpawning();
    }
}

