/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import greekfantasy.client.entity.layer.HalfHorseLayer;
import greekfantasy.client.entity.layer.HalfHorseMarkingsLayer;
import greekfantasy.client.entity.layer.QuiverLayer;
import greekfantasy.client.entity.model.CyprianModel;
import greekfantasy.entity.monster.Cyprian;
import java.util.EnumMap;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.Variant;

public class CyprianRenderer<T extends Cyprian>
extends HumanoidMobRenderer<T, CyprianModel<T>> {
    public static final EnumMap<Variant, ResourceLocation> BODY_TEXTURE_MAP = new EnumMap(Variant.class);

    public CyprianRenderer(EntityRendererProvider.Context context) {
        super(context, new CyprianModel(context.bakeLayer(CyprianModel.CYPRIAN_MODEL_RESOURCE)), 0.75f);
        this.addLayer(new HalfHorseLayer(this, context.getModelSet()));
        this.addLayer(new HalfHorseMarkingsLayer(this, context.getModelSet()));
        this.addLayer(new QuiverLayer(this));
    }

    public ResourceLocation getTextureLocation(T entity) {
        return BODY_TEXTURE_MAP.get(entity.getVariant());
    }

    static {
        BODY_TEXTURE_MAP.put(Variant.BLACK, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/cyprian/black.png"));
        BODY_TEXTURE_MAP.put(Variant.BROWN, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/cyprian/brown.png"));
        BODY_TEXTURE_MAP.put(Variant.CHESTNUT, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/cyprian/chestnut.png"));
        BODY_TEXTURE_MAP.put(Variant.CREAMY, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/cyprian/creamy.png"));
        BODY_TEXTURE_MAP.put(Variant.DARK_BROWN, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/cyprian/darkbrown.png"));
        BODY_TEXTURE_MAP.put(Variant.GRAY, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/cyprian/gray.png"));
        BODY_TEXTURE_MAP.put(Variant.WHITE, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/cyprian/white.png"));
    }
}

