/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import greekfantasy.entity.misc.DragonToothHook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class DragonToothHookRenderer
extends EntityRenderer<DragonToothHook> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/dragon_tooth_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutout((ResourceLocation)TEXTURE_LOCATION);
    private static final double VIEW_BOBBING_SCALE = 960.0;

    public DragonToothHookRenderer(EntityRendererProvider.Context parent) {
        super(parent);
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v) {
        vertexConsumer.addVertex(pose, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(-1).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private static float fraction(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    public void render(DragonToothHook entity, float renderOffsetX, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        Player player = entity.getPlayerOwner();
        if (player != null) {
            float f3;
            double d6;
            double d5;
            double d4;
            poseStack.pushPose();
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            PoseStack.Pose posestack$pose = poseStack.last();
            VertexConsumer vertexconsumer = multiBufferSource.getBuffer(RENDER_TYPE);
            DragonToothHookRenderer.vertex(vertexconsumer, posestack$pose, packedLight, 0.0f, 0, 0, 1);
            DragonToothHookRenderer.vertex(vertexconsumer, posestack$pose, packedLight, 1.0f, 0, 1, 1);
            DragonToothHookRenderer.vertex(vertexconsumer, posestack$pose, packedLight, 1.0f, 1, 1, 0);
            DragonToothHookRenderer.vertex(vertexconsumer, posestack$pose, packedLight, 0.0f, 1, 0, 0);
            poseStack.popPose();
            int i = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack itemstack = player.getMainHandItem();
            if (!(itemstack.getItem() instanceof FishingRodItem)) {
                i = -i;
            }
            float f = player.getAttackAnim(partialTick);
            float f1 = Mth.sin((float)(Mth.sqrt((float)f) * (float)Math.PI));
            float f2 = Mth.lerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
            double d0 = Mth.sin((float)f2);
            double d1 = Mth.cos((float)f2);
            double d2 = (double)i * 0.35;
            double d3 = 0.8;
            if ((this.entityRenderDispatcher.options == null || this.entityRenderDispatcher.options.getCameraType().isFirstPerson()) && player == Minecraft.getInstance().player) {
                double d7 = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
                Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.525f, -0.1f);
                vec3 = vec3.scale(d7);
                vec3 = vec3.yRot(f1 * 0.5f);
                vec3 = vec3.xRot(-f1 * 0.7f);
                d4 = Mth.lerp((double)partialTick, (double)player.xo, (double)player.getX()) + vec3.x;
                d5 = Mth.lerp((double)partialTick, (double)player.yo, (double)player.getY()) + vec3.y;
                d6 = Mth.lerp((double)partialTick, (double)player.zo, (double)player.getZ()) + vec3.z;
                f3 = player.getEyeHeight();
            } else {
                d4 = Mth.lerp((double)partialTick, (double)player.xo, (double)player.getX()) - d1 * d2 - d0 * 0.8;
                d5 = player.yo + (double)player.getEyeHeight() + (player.getY() - player.yo) * (double)partialTick - 0.45;
                d6 = Mth.lerp((double)partialTick, (double)player.zo, (double)player.getZ()) - d0 * d2 + d1 * 0.8;
                f3 = player.isCrouching() ? -0.1875f : 0.0f;
            }
            double d9 = Mth.lerp((double)partialTick, (double)entity.xo, (double)entity.getX());
            double d10 = Mth.lerp((double)partialTick, (double)entity.yo, (double)entity.getY()) + 0.25;
            double d8 = Mth.lerp((double)partialTick, (double)entity.zo, (double)entity.getZ());
            float f4 = (float)(d4 - d9);
            float f5 = (float)(d5 - d10) + f3;
            float f6 = (float)(d6 - d8);
            VertexConsumer vertexconsumer1 = multiBufferSource.getBuffer(RenderType.lineStrip());
            PoseStack.Pose posestack$pose1 = poseStack.last();
            int j = 16;
            for (int k = 0; k <= 16; ++k) {
                DragonToothHookRenderer.stringVertex(f4, f5, f6, vertexconsumer1, posestack$pose1, DragonToothHookRenderer.fraction(k, 16), DragonToothHookRenderer.fraction(k + 1, 16));
            }
            poseStack.popPose();
            super.render((Entity)entity, renderOffsetX, partialTick, poseStack, multiBufferSource, packedLight);
        }
    }

    public static void stringVertex(float x, float y, float z, VertexConsumer vertexConsumer, PoseStack.Pose pose, float startPercent, float endPercent) {
        float f = x * startPercent;
        float f1 = y * (startPercent * startPercent + startPercent) * 0.5f + 0.25f;
        float f2 = z * startPercent;
        float f3 = x * endPercent - f;
        float f4 = y * (endPercent * endPercent + endPercent) * 0.5f + 0.25f - f1;
        float f5 = z * endPercent - f2;
        float f6 = Mth.sqrt((float)(f3 * f3 + f4 * f4 + f5 * f5));
        vertexConsumer.addVertex(pose, f, f1, f2).setColor(255, 204, 0, 255).setNormal(pose, f3 /= f6, f4 /= f6, f5 /= f6);
    }

    public ResourceLocation getTextureLocation(DragonToothHook entity) {
        return TEXTURE_LOCATION;
    }
}

