/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import greekfantasy.client.entity.model.NymphModel;
import greekfantasy.entity.Dryad;
import greekfantasy.entity.util.NymphVariant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;

public class DryadRenderer<T extends Dryad>
extends MobRenderer<T, NymphModel<T>> {
    public static final Map<NymphVariant, ResourceLocation> TEXTURE_MAP = new HashMap<NymphVariant, ResourceLocation>();

    public DryadRenderer(EntityRendererProvider.Context context) {
        super(context, new NymphModel(context.bakeLayer(NymphModel.NYMPH_LAYER_LOCATION), false), 0.4f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE_MAP.get(((Dryad)entity).getVariant());
    }

    static {
        TEXTURE_MAP.put(Dryad.Variant.ACACIA, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/dryad/acacia.png"));
        TEXTURE_MAP.put(Dryad.Variant.BIRCH, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/dryad/birch.png"));
        TEXTURE_MAP.put(Dryad.Variant.DARK_OAK, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/dryad/dark_oak.png"));
        TEXTURE_MAP.put(Dryad.Variant.JUNGLE, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/dryad/jungle.png"));
        TEXTURE_MAP.put(Dryad.Variant.OAK, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/dryad/oak.png"));
        TEXTURE_MAP.put(Dryad.Variant.OLIVE, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/dryad/olive.png"));
        TEXTURE_MAP.put(Dryad.Variant.SPRUCE, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/dryad/spruce.png"));
    }
}

