/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class FakePigRenderer<T extends LivingEntity>
extends LivingEntityRenderer<T, PigModel<T>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/pig/pig.png");

    public FakePigRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PigModel(context.bakeLayer(ModelLayers.PIG)), 0.7f);
    }

    public void render(T entity, float renderOffsetX, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        Direction direction;
        boolean shouldSit;
        poseStack.pushPose();
        ((PigModel)this.model).attackTime = this.getAttackAnim((LivingEntity)entity, partialTick);
        ((PigModel)this.model).riding = shouldSit = entity.isPassenger() && entity.getVehicle() != null && entity.getVehicle().shouldRiderSit();
        ((PigModel)this.model).young = entity.isBaby();
        float f = Mth.rotLerp((float)partialTick, (float)((LivingEntity)entity).yBodyRotO, (float)((LivingEntity)entity).yBodyRot);
        float f1 = Mth.rotLerp((float)partialTick, (float)((LivingEntity)entity).yHeadRotO, (float)((LivingEntity)entity).yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && entity.getVehicle() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.getVehicle();
            f = Mth.rotLerp((float)partialTick, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTick, (float)((LivingEntity)entity).xRotO, (float)entity.getXRot());
        if (FakePigRenderer.isEntityUpsideDown(entity)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        if (entity.getPose() == Pose.SLEEPING && (direction = entity.getBedOrientation()) != null) {
            float f4 = entity.getEyeHeight(Pose.STANDING) - 0.1f;
            poseStack.translate((double)((float)(-direction.getStepX()) * f4), 0.0, (double)((float)(-direction.getStepZ()) * f4));
        }
        float f7 = this.getBob((LivingEntity)entity, partialTick);
        this.setupRotations((LivingEntity)entity, poseStack, f7, f, partialTick, 1.0f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntity)entity, poseStack, partialTick);
        poseStack.translate(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entity.isAlive()) {
            f8 = ((LivingEntity)entity).walkAnimation.speed(partialTick);
            f5 = ((LivingEntity)entity).walkAnimation.position() - ((LivingEntity)entity).walkAnimation.speed() * (1.0f - partialTick);
            if (entity.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((PigModel)this.model).prepareMobModel(entity, f5, f8, partialTick);
        ((PigModel)this.model).setupAnim(entity, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = this.isBodyVisible((LivingEntity)entity);
        boolean flag1 = !flag && !entity.isInvisibleTo((Player)minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing(entity);
        RenderType rendertype = this.getRenderType((LivingEntity)entity, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = multiBufferSource.getBuffer(rendertype);
            int i = FakePigRenderer.getOverlayCoords(entity, (float)this.getWhiteOverlayProgress((LivingEntity)entity, partialTick));
            int color = flag1 ? 0x26FFFFFF : -1;
            ((PigModel)this.model).renderToBuffer(poseStack, vertexconsumer, packedLight, i, color);
        }
        if (!entity.isSpectator()) {
            for (RenderLayer renderlayer : this.layers) {
                renderlayer.render(poseStack, multiBufferSource, packedLight, entity, f5, f8, partialTick, f7, f2, f6);
            }
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }
}

