/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import greekfantasy.client.entity.layer.GeryonClothingLayer;
import greekfantasy.client.entity.model.GeryonModel;
import greekfantasy.entity.boss.Geryon;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.resources.ResourceLocation;

public class GeryonRenderer<T extends Geryon>
extends HumanoidMobRenderer<T, GeryonModel<T>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/geryon/geryon.png");
    private static final float SCALE = 2.0f;

    public GeryonRenderer(EntityRendererProvider.Context context) {
        super(context, new GeryonModel(context.bakeLayer(GeryonModel.GERYON_MODEL_RESOURCE)), 1.0f);
        this.addLayer(new GeryonClothingLayer(this, context.getModelSet()));
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }

    protected void scale(T entity, PoseStack poseStack, float f) {
        if (((Geryon)entity).isSpawning()) {
            float height = 4.96f;
            float translateY = 4.96f * ((Geryon)entity).getSpawnPercent(f) - 4.96f;
            poseStack.translate(0.0, (double)(-translateY), 0.0);
        }
        poseStack.scale(2.0f, 2.0f, 2.0f);
    }

    protected boolean isShaking(T entity) {
        return ((Geryon)entity).isSpawning();
    }
}

