/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import greekfantasy.client.entity.model.GiantBoarModel;
import greekfantasy.entity.boss.GiantBoar;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class GiantBoarRenderer<T extends GiantBoar>
extends MobRenderer<T, GiantBoarModel<T>> {
    private static final ResourceLocation HOGLIN_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/hoglin/hoglin.png");
    private static final ResourceLocation GIANT_BOAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/giant_boar.png");
    public static final float SCALE = 1.9f;
    protected boolean isAlphaLayer;

    public GiantBoarRenderer(EntityRendererProvider.Context context) {
        super(context, new GiantBoarModel(context.bakeLayer(ModelLayers.HOGLIN)), 1.0f);
    }

    public void render(T entity, float renderOffsetX, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.pushPose();
        float spawnPercent = ((GiantBoar)((Object)entity)).getSpawnPercent(partialTick);
        float scale = 1.0f + 0.9f * spawnPercent;
        poseStack.scale(scale, scale, scale);
        ((GiantBoarModel)this.getModel()).setColorAlpha(1.0f);
        super.render(entity, renderOffsetX, partialTick, poseStack, multiBufferSource, packedLight);
        if (spawnPercent < 0.99f) {
            this.isAlphaLayer = true;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            ((GiantBoarModel)this.model).setColorAlpha(1.0f - spawnPercent);
            super.render(entity, renderOffsetX, partialTick, poseStack, multiBufferSource, packedLight);
            RenderSystem.disableBlend();
            this.isAlphaLayer = false;
        }
        poseStack.popPose();
    }

    protected boolean isShaking(T entity) {
        return ((GiantBoar)((Object)entity)).isConverting();
    }

    protected void scale(T entity, PoseStack matrix, float ageInTicks) {
    }

    public ResourceLocation getTextureLocation(T entity) {
        return GIANT_BOAR_TEXTURE;
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing) {
        if (this.isAlphaLayer && (isVisible || isVisibleToPlayer)) {
            return RenderType.entityTranslucent((ResourceLocation)HOGLIN_TEXTURE, (boolean)isGlowing);
        }
        return super.getRenderType(entity, isVisible, isVisibleToPlayer, isGlowing);
    }
}

