/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import greekfantasy.client.entity.model.NymphModel;
import greekfantasy.entity.Dryad;
import greekfantasy.entity.Lampad;
import greekfantasy.entity.util.NymphVariant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;

public class LampadRenderer<T extends Lampad>
extends MobRenderer<T, NymphModel<T>> {
    public static final Map<NymphVariant, ResourceLocation> TEXTURE_MAP = new HashMap<NymphVariant, ResourceLocation>();

    public LampadRenderer(EntityRendererProvider.Context context) {
        super(context, new NymphModel(context.bakeLayer(NymphModel.NYMPH_LAYER_LOCATION), false), 0.4f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE_MAP.get(((Dryad)entity).getVariant());
    }

    static {
        TEXTURE_MAP.put(Lampad.Variant.CRIMSON, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/lampad/crimson.png"));
        TEXTURE_MAP.put(Lampad.Variant.WARPED, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/lampad/warped.png"));
        TEXTURE_MAP.put(Lampad.Variant.POMEGRANATE, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/lampad/pomegranate.png"));
    }
}

