/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import greekfantasy.client.entity.layer.PalladiumTorchLayer;
import greekfantasy.client.entity.model.PalladiumModel;
import greekfantasy.entity.Palladium;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.model.data.ModelData;

public class PalladiumRenderer<T extends Palladium>
extends LivingEntityRenderer<T, PalladiumModel<T>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/palladium.png");

    public PalladiumRenderer(EntityRendererProvider.Context context) {
        super(context, new PalladiumModel(context.bakeLayer(PalladiumModel.PALLADIUM_MODEL_RESOURCE)), 0.0f);
        this.addLayer(new PalladiumTorchLayer(this));
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLightIn) {
        poseStack.translate(-0.5, 0.0, -0.5);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(Blocks.OAK_SLAB.defaultBlockState(), poseStack, multiBufferSource, packedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        poseStack.translate(0.5, 0.5, 0.5);
        super.render(entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLightIn);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }

    protected boolean shouldShowName(T entity) {
        return entity.shouldShowName() && entity.hasCustomName() && super.shouldShowName(entity);
    }
}

