/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import greekfantasy.client.entity.layer.SatyrGroverLayer;
import greekfantasy.client.entity.layer.SatyrPanfluteLayer;
import greekfantasy.client.entity.layer.SatyrShamanLayer;
import greekfantasy.client.entity.model.SatyrModel;
import greekfantasy.entity.Satyr;
import java.util.EnumMap;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.Variant;

public class SatyrRenderer<T extends Satyr>
extends MobRenderer<T, SatyrModel<T>> {
    private static final ResourceLocation TEXTURE_GROVER = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/satyr/grover.png");
    public static final EnumMap<Variant, ResourceLocation> BODY_TEXTURE_MAP = new EnumMap(Variant.class);

    public SatyrRenderer(EntityRendererProvider.Context context) {
        super(context, new SatyrModel(context.bakeLayer(SatyrModel.SATYR_MODEL_RESOURCE)), 0.5f);
        this.addLayer(new SatyrShamanLayer(this, context.getModelSet()));
        this.addLayer(new SatyrPanfluteLayer(this));
        this.addLayer(new SatyrGroverLayer(this, context.getModelSet()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (entity.hasCustomName() && "Grover".equals(entity.getCustomName().getString())) {
            return TEXTURE_GROVER;
        }
        return BODY_TEXTURE_MAP.get(entity.getVariant());
    }

    static {
        BODY_TEXTURE_MAP.put(Variant.BLACK, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/satyr/black.png"));
        BODY_TEXTURE_MAP.put(Variant.BROWN, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/satyr/brown.png"));
        BODY_TEXTURE_MAP.put(Variant.CHESTNUT, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/satyr/chestnut.png"));
        BODY_TEXTURE_MAP.put(Variant.CREAMY, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/satyr/creamy.png"));
        BODY_TEXTURE_MAP.put(Variant.DARK_BROWN, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/satyr/darkbrown.png"));
        BODY_TEXTURE_MAP.put(Variant.GRAY, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/satyr/gray.png"));
        BODY_TEXTURE_MAP.put(Variant.WHITE, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/satyr/white.png"));
    }
}

