/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import greekfantasy.client.entity.model.ShadeModel;
import greekfantasy.entity.monster.Shade;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ShadeRenderer<T extends Shade>
extends HumanoidMobRenderer<T, HumanoidModel<T>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/shade.png");

    public ShadeRenderer(EntityRendererProvider.Context context) {
        super(context, new ShadeModel(context.bakeLayer(ShadeModel.SHADE_MODEL_RESOURCE)), 0.5f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    protected void scale(T entity, PoseStack poseStack, float partialTick) {
        float ticks = (float)(entity.getId() * 2 + ((Shade)((Object)entity)).tickCount) + partialTick;
        float translateY = 0.15f * Mth.cos((float)(ticks * 0.1f)) + 0.25f;
        poseStack.translate(0.0, (double)translateY, 0.0);
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render(entity, entityYaw, partialTick, poseStack, bufferSource, 0xF000F0);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }
}

