/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import greekfantasy.client.entity.layer.SpartiClothingLayer;
import greekfantasy.entity.Sparti;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;

public class SpartiRenderer<T extends Sparti>
extends HumanoidMobRenderer<T, SkeletonModel<T>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/sparti/sparti.png");

    public SpartiRenderer(EntityRendererProvider.Context context) {
        this(context, ModelLayers.SKELETON, ModelLayers.SKELETON_INNER_ARMOR, ModelLayers.SKELETON_OUTER_ARMOR);
    }

    public SpartiRenderer(EntityRendererProvider.Context context, ModelLayerLocation model, ModelLayerLocation innerArmor, ModelLayerLocation outerArmor) {
        super(context, (HumanoidModel)new SkeletonModel(context.bakeLayer(model)), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new SkeletonModel(context.bakeLayer(innerArmor)), (HumanoidModel)new SkeletonModel(context.bakeLayer(outerArmor)), Minecraft.getInstance().getModelManager()));
        this.addLayer(new SpartiClothingLayer(this, context.getModelSet()));
    }

    protected void scale(T entity, PoseStack poseStack, float partialTick) {
        if (((Sparti)((Object)entity)).isSpawning()) {
            float height = 1.99f;
            float translateY = 1.99f * ((Sparti)((Object)entity)).getSpawnPercent() - 1.99f;
            poseStack.translate(0.0f, -translateY, 0.0f);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }

    protected boolean isShaking(T entity) {
        return ((Sparti)((Object)entity)).isSpawning();
    }
}

