/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import greekfantasy.client.entity.model.SpearModel;
import greekfantasy.entity.misc.Spear;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class SpearRenderer<T extends Spear>
extends EntityRenderer<T> {
    private final SpearModel model;

    public SpearRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SpearModel(context.bakeLayer(SpearModel.SPEAR_MODEL_RESOURCE));
    }

    public void render(T entity, float renderOffsetX, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)((Spear)((Object)entity)).yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)((Spear)((Object)entity)).xRotO, (float)entity.getXRot()) + 90.0f));
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)this.model.renderType(this.getTextureLocation(entity)), (boolean)false, (boolean)((Spear)((Object)entity)).hasFoil());
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render(entity, renderOffsetX, partialTick, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ((Spear)((Object)entity)).getTexture();
    }

    public static class SpearItemStackRenderer
    extends BlockEntityWithoutLevelRenderer {
        private final EntityModelSet entityModelSet;
        private final ResourceLocation texture;
        private SpearModel spearModel;

        public SpearItemStackRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet entityModelSet, ResourceLocation name) {
            super(dispatcher, entityModelSet);
            this.entityModelSet = entityModelSet;
            this.spearModel = new SpearModel(this.entityModelSet.bakeLayer(SpearModel.SPEAR_MODEL_RESOURCE));
            this.texture = ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("textures/entity/spear/" + name.getPath() + ".png"));
        }

        public void onResourceManagerReload(ResourceManager resourceManager) {
            this.spearModel = new SpearModel(this.entityModelSet.bakeLayer(SpearModel.SPEAR_MODEL_RESOURCE));
        }

        public void renderByItem(ItemStack item, ItemDisplayContext transform, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
            poseStack.pushPose();
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            VertexConsumer vertexBuilder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)this.spearModel.renderType(this.texture), (boolean)false, (boolean)item.hasFoil());
            this.spearModel.renderToBuffer(poseStack, vertexBuilder, combinedLightIn, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

