/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.client.entity.model.SpellModel;
import greekfantasy.entity.misc.Curse;
import greekfantasy.entity.misc.CurseOfCirce;
import greekfantasy.entity.misc.HealingSpell;
import greekfantasy.entity.misc.PoisonSpit;
import greekfantasy.entity.misc.WaterSpell;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;

public abstract class SpellRenderer<T extends Projectile>
extends EntityRenderer<T> {
    protected SpellModel<T> entityModel;
    protected boolean usePackedLight;

    public SpellRenderer(EntityRendererProvider.Context context) {
        this(context, true);
    }

    public SpellRenderer(EntityRendererProvider.Context context, boolean usePackedLight) {
        super(context);
        this.entityModel = new SpellModel(context.bakeLayer(SpellModel.SPELL_MODEL_RESOURCE));
        this.usePackedLight = usePackedLight;
    }

    public void render(T entity, float renderOffsetX, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        this.entityModel.prepareMobModel((Entity)entity, 0.0f, 0.0f, partialTick);
        this.entityModel.setupAnim(entity, 0.0f, 0.0f, (float)((Projectile)entity).tickCount + partialTick, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(this.entityModel.renderType(this.getTextureLocation((Entity)entity)));
        int light = this.usePackedLight ? packedLight : 0xF000F0;
        this.entityModel.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }

    public static class WaterSpellRenderer
    extends SpellRenderer<WaterSpell> {
        private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/water_spell.png");

        public WaterSpellRenderer(EntityRendererProvider.Context context) {
            super(context);
        }

        public ResourceLocation getTextureLocation(WaterSpell entity) {
            return TEXTURE;
        }
    }

    public static class PoisonSpitRenderer
    extends SpellRenderer<PoisonSpit> {
        private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/poison_spit.png");

        public PoisonSpitRenderer(EntityRendererProvider.Context context) {
            super(context);
        }

        public ResourceLocation getTextureLocation(PoisonSpit entity) {
            return TEXTURE;
        }
    }

    public static class HealingSpellRenderer
    extends SpellRenderer<HealingSpell> {
        private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/healing_spell.png");

        public HealingSpellRenderer(EntityRendererProvider.Context context) {
            super(context, false);
        }

        public ResourceLocation getTextureLocation(HealingSpell entity) {
            return TEXTURE;
        }
    }

    public static class CurseOfCirceRenderer
    extends SpellRenderer<CurseOfCirce> {
        private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/curse_of_circe.png");

        public CurseOfCirceRenderer(EntityRendererProvider.Context context) {
            super(context);
        }

        public ResourceLocation getTextureLocation(CurseOfCirce entity) {
            return TEXTURE;
        }
    }

    public static class CurseRenderer
    extends SpellRenderer<Curse> {
        private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/curse.png");

        public CurseRenderer(EntityRendererProvider.Context context) {
            super(context, false);
        }

        public ResourceLocation getTextureLocation(Curse entity) {
            return TEXTURE;
        }
    }
}

