/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.entity.Automaton;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;

public class AutomatonCrackinessLayer<T extends Automaton, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation[] CRACKINESS = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/automaton/automaton_crackiness_high.png"), ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/automaton/automaton_crackiness_medium.png"), ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/automaton/automaton_crackiness_low.png")};

    public AutomatonCrackinessLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int crackiness = ((Automaton)entity).getCrackiness();
        if (crackiness >= 0 && crackiness < 3 && !entity.isInvisible()) {
            ResourceLocation texture = CRACKINESS[crackiness];
            VertexConsumer vertexconsumer = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture));
            this.getParentModel().renderToBuffer(poseStack, vertexconsumer, packedLight, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f), -2130706433);
        }
    }
}

