/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.client.entity.model.FuryModel;
import greekfantasy.entity.monster.Fury;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;

public class FuryHairLayer<T extends Fury>
extends RenderLayer<T, FuryModel<T>> {
    public FuryHairLayer(RenderLayerParent<T, FuryModel<T>> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        float aggroPercent = ((Fury)((Object)entity)).getAggroPercent(partialTick);
        if (aggroPercent > 0.05f) {
            float scale = 0.25f + aggroPercent * 0.75f;
            int packedOverlay = LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f);
            VertexConsumer vertexBuilder = multiBufferSource.getBuffer(((FuryModel)this.getParentModel()).renderType(this.getTextureLocation((Entity)entity)));
            poseStack.pushPose();
            poseStack.scale(scale, scale, scale);
            ((FuryModel)this.getParentModel()).setupSnakeAnim(ageInTicks);
            ((FuryModel)this.getParentModel()).getHair().render(poseStack, vertexBuilder, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }
}

