/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.client.entity.model.HalfHorseModel;
import greekfantasy.entity.util.HasHorseVariant;
import java.util.EnumMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Variant;

public class HalfHorseLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final EnumMap<Variant, ResourceLocation> BODY_TEXTURES = new EnumMap(Variant.class);
    private final HalfHorseModel<T> layerModel;

    public HalfHorseLayer(RenderLayerParent<T, M> parent, EntityModelSet entityModelSet) {
        super(parent);
        this.layerModel = new HalfHorseModel(entityModelSet.bakeLayer(HalfHorseModel.HALF_HORSE_MODEL_RESOURCE));
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        this.layerModel.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        this.layerModel.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        int packedOverlay = LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(this.layerModel.renderType(this.getTextureLocation(entity)));
        this.layerModel.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, -1);
    }

    protected ResourceLocation getTextureLocation(T entity) {
        return BODY_TEXTURES.get(((HasHorseVariant)entity).getVariant());
    }

    static {
        BODY_TEXTURES.put(Variant.BLACK, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/horse/horse_black.png"));
        BODY_TEXTURES.put(Variant.BROWN, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/horse/horse_brown.png"));
        BODY_TEXTURES.put(Variant.CHESTNUT, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/horse/horse_chestnut.png"));
        BODY_TEXTURES.put(Variant.CREAMY, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/horse/horse_creamy.png"));
        BODY_TEXTURES.put(Variant.DARK_BROWN, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/horse/horse_darkbrown.png"));
        BODY_TEXTURES.put(Variant.GRAY, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/horse/horse_gray.png"));
        BODY_TEXTURES.put(Variant.WHITE, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/horse/horse_white.png"));
    }
}

