/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.client.entity.model.HalfHorseModel;
import greekfantasy.entity.util.HasHorseVariant;
import java.util.EnumMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.Markings;

public class HalfHorseMarkingsLayer<T extends Mob, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final EnumMap<Markings, ResourceLocation> MARKINGS_TEXTURES = new EnumMap(Markings.class);
    private EntityModel<T> model;

    public HalfHorseMarkingsLayer(RenderLayerParent<T, M> parent, EntityModelSet modelSet) {
        super(parent);
        this.model = new HalfHorseModel(modelSet.bakeLayer(HalfHorseModel.HALF_HORSE_MODEL_RESOURCE));
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation texture = this.getTextureLocation(entity);
        if (texture != null) {
            this.getParentModel().copyPropertiesTo(this.model);
            this.model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
            this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vertexBuilder = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture));
            this.model.renderToBuffer(poseStack, vertexBuilder, packedLight, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f), -1);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return MARKINGS_TEXTURES.get(((HasHorseVariant)entity).getMarkings());
    }

    static {
        MARKINGS_TEXTURES.put(Markings.NONE, null);
        MARKINGS_TEXTURES.put(Markings.WHITE, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_markings_white.png"));
        MARKINGS_TEXTURES.put(Markings.WHITE_FIELD, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_markings_whitefield.png"));
        MARKINGS_TEXTURES.put(Markings.WHITE_DOTS, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_markings_whitedots.png"));
        MARKINGS_TEXTURES.put(Markings.BLACK_DOTS, ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_markings_blackdots.png"));
    }
}

