/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import greekfantasy.client.entity.model.MakhaiModel;
import greekfantasy.entity.Makhai;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class MakhaiHeldItemLayer<T extends Makhai>
extends RenderLayer<T, MakhaiModel<T>> {
    public MakhaiHeldItemLayer(RenderLayerParent<T, MakhaiModel<T>> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.isInvisible()) {
            ItemStack left = entity.getItemBySlot(EquipmentSlot.OFFHAND);
            ItemStack right = entity.getItemBySlot(EquipmentSlot.MAINHAND);
            if (!left.isEmpty()) {
                this.renderItem(poseStack, multiBufferSource, packedLight, entity, ((MakhaiModel)this.getParentModel()).backRightArm, left, 0.0f, 0.0f, 0.0f, 0.0f);
                this.renderItem(poseStack, multiBufferSource, packedLight, entity, ((MakhaiModel)this.getParentModel()).backLeftArm, left, -0.175f, 0.025f, 0.0f, 0.0f);
            }
            if (!right.isEmpty()) {
                this.renderItem(poseStack, multiBufferSource, packedLight, entity, ((MakhaiModel)this.getParentModel()).frontLeftArm, right, -0.125f, 0.0f, 0.0f, 0.0f);
                this.renderItem(poseStack, multiBufferSource, packedLight, entity, ((MakhaiModel)this.getParentModel()).frontRightArm, right, 0.125f, 0.175f, 0.0f, -90.0f);
            }
        }
    }

    private void renderItem(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, ModelPart arm, ItemStack item, float offsetX, float offsetY, float offsetZ, float rotation) {
        poseStack.pushPose();
        arm.translateAndRotate(poseStack);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(0.0625, 0.125, -0.625);
        poseStack.translate((double)offsetX, (double)offsetY - 0.3, (double)offsetZ + 0.125);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
        Minecraft.getInstance().getItemRenderer().renderStatic(entity, item, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, poseStack, multiBufferSource, entity.getCommandSenderWorld(), packedLight, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }
}

