/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import greekfantasy.client.entity.model.PalladiumModel;
import greekfantasy.entity.Palladium;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PalladiumTorchLayer<T extends Palladium>
extends RenderLayer<T, PalladiumModel<T>> {
    private static final ItemStack itemStack = new ItemStack((ItemLike)Items.SOUL_TORCH);

    public PalladiumTorchLayer(RenderLayerParent<T, PalladiumModel<T>> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.isInvisible()) {
            poseStack.pushPose();
            ((PalladiumModel)this.getParentModel()).translateToHand(HumanoidArm.RIGHT, poseStack);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(0.0625, 0.125, -0.625);
            Minecraft.getInstance().getItemRenderer().renderStatic(entity, itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, poseStack, multiBufferSource, entity.level(), packedLightIn, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }
}

