/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.client.entity.model.PegasusModel;
import greekfantasy.entity.Pegasus;
import java.util.EnumMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.Variant;

public class PegasusWingLayer<T extends Pegasus>
extends RenderLayer<T, PegasusModel<T>> {
    public static final EnumMap<Variant, ResourceLocation> WING_TEXTURE_MAP = new EnumMap(Variant.class);

    public PegasusWingLayer(RenderLayerParent<T, PegasusModel<T>> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        int packedOverlay = LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f);
        VertexConsumer vertexBuilder = multiBufferSource.getBuffer(((PegasusModel)this.getParentModel()).renderType(this.getTextureLocation(entity)));
        poseStack.pushPose();
        if (entity.isBaby()) {
            float scale = 0.5f;
            float childBodyOffsetY = 20.0f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(0.0, (double)(childBodyOffsetY / 16.0f), 0.0);
        }
        ((PegasusModel)this.getParentModel()).renderWings(entity, poseStack, vertexBuilder, packedLight, packedOverlay, limbSwing, limbSwingAmount, partialTick);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(T entity) {
        return WING_TEXTURE_MAP.get(entity.getVariant());
    }

    static {
        WING_TEXTURE_MAP.put(Variant.BLACK, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/pegasus/black.png"));
        WING_TEXTURE_MAP.put(Variant.BROWN, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/pegasus/brown.png"));
        WING_TEXTURE_MAP.put(Variant.CHESTNUT, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/pegasus/chestnut.png"));
        WING_TEXTURE_MAP.put(Variant.CREAMY, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/pegasus/creamy.png"));
        WING_TEXTURE_MAP.put(Variant.DARK_BROWN, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/pegasus/darkbrown.png"));
        WING_TEXTURE_MAP.put(Variant.GRAY, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/pegasus/gray.png"));
        WING_TEXTURE_MAP.put(Variant.WHITE, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/pegasus/white.png"));
    }
}

