/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.model.data.ModelData;

public class PlayerSoulFireLayer<T extends Player>
extends RenderLayer<T, PlayerModel<T>> {
    public PlayerSoulFireLayer(RenderLayerParent<T, PlayerModel<T>> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack item = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (!entity.isInvisible() && !item.isEmpty() && item.has(DataComponents.CUSTOM_NAME) && "skyjay1".equals(item.getHoverName().getString())) {
            float scale = 0.5f;
            poseStack.pushPose();
            ((PlayerModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
            poseStack.translate(0.25, -0.5, -0.25);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.scale(0.5f, -0.5f, -0.5f);
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(Blocks.SOUL_FIRE.defaultBlockState(), poseStack, multiBufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
            poseStack.popPose();
        }
    }
}

