/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.client.entity.model.CentaurModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BowItem;

public class QuiverLayer<T extends Mob, M extends CentaurModel<T>>
extends RenderLayer<T, M> {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/centaur/quiver.png");

    public QuiverLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.getMainHandItem().getItem() instanceof BowItem || entity.getOffhandItem().getItem() instanceof BowItem) {
            int packedOverlay = LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f);
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(((CentaurModel)this.getParentModel()).renderType(this.getTextureLocation(entity)));
            ((CentaurModel)this.getParentModel()).renderQuiver(entity, poseStack, vertexConsumer, packedLight, packedOverlay, limbSwing, limbSwingAmount);
        }
    }

    protected ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }
}

