/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import greekfantasy.GFRegistry;
import greekfantasy.client.entity.model.SatyrModel;
import greekfantasy.entity.Satyr;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SatyrPanfluteLayer<T extends Satyr>
extends RenderLayer<T, SatyrModel<T>> {
    private static ItemStack panflute;

    public SatyrPanfluteLayer(RenderLayerParent<T, SatyrModel<T>> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (null == panflute) {
            panflute = new ItemStack((ItemLike)GFRegistry.ItemReg.PANFLUTE.get());
        }
        if (!entity.isInvisible() && ((Satyr)entity).holdingPanfluteTime > 0) {
            poseStack.pushPose();
            ((SatyrModel)this.getParentModel()).translateToHand(HumanoidArm.RIGHT, poseStack);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(0.0625f, 0.125f, -0.625f);
            Minecraft.getInstance().getItemRenderer().renderStatic(entity, panflute, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, poseStack, multiBufferSource, entity.level(), packedLight, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }
}

