/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import greekfantasy.entity.boss.Arachne;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ArachneModel<T extends Arachne>
extends HumanoidModel<T> {
    public static final ModelLayerLocation ARACHNE_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"arachne"), "arachne");
    private final ModelPart torso;
    private final ModelPart body0;
    private final ModelPart body1;
    private final ModelPart spiderLeg0;
    private final ModelPart spiderFoot0;
    private final ModelPart spiderLeg1;
    private final ModelPart spiderFoot1;
    private final ModelPart spiderLeg2;
    private final ModelPart spiderFoot2;
    private final ModelPart spiderLeg3;
    private final ModelPart spiderFoot3;
    private final ModelPart spiderLeg4;
    private final ModelPart spiderFoot4;
    private final ModelPart spiderLeg5;
    private final ModelPart spiderFoot5;
    private final ModelPart spiderLeg6;
    private final ModelPart spiderFoot6;
    private final ModelPart spiderLeg7;
    private final ModelPart spiderFoot7;

    public ArachneModel(ModelPart root) {
        super(root);
        this.torso = root.getChild("torso");
        this.body0 = root.getChild("body0");
        this.body1 = root.getChild("body1");
        this.spiderLeg0 = root.getChild("leg0");
        this.spiderFoot0 = this.spiderLeg0.getChild("foot0");
        this.spiderLeg1 = root.getChild("leg1");
        this.spiderFoot1 = this.spiderLeg1.getChild("foot1");
        this.spiderLeg2 = root.getChild("leg2");
        this.spiderFoot2 = this.spiderLeg2.getChild("foot2");
        this.spiderLeg3 = root.getChild("leg3");
        this.spiderFoot3 = this.spiderLeg3.getChild("foot3");
        this.spiderLeg4 = root.getChild("leg4");
        this.spiderFoot4 = this.spiderLeg4.getChild("foot4");
        this.spiderLeg5 = root.getChild("leg5");
        this.spiderFoot5 = this.spiderLeg5.getChild("foot5");
        this.spiderLeg6 = root.getChild("leg6");
        this.spiderFoot6 = this.spiderLeg6.getChild("foot6");
        this.spiderLeg7 = root.getChild("leg7");
        this.spiderFoot7 = this.spiderLeg7.getChild("foot7");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(25, 0).addBox(1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(25, 0).addBox(-2.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-4.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(42, 16).addBox(-3.0f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-4.0f, (float)1.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(42, 16).mirror().addBox(0.0f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)4.0f, (float)1.0f, (float)-3.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 16).addBox(-4.0f, -24.0f, -5.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-23.0f, (float)-5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(33, 50).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)-5.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body0", CubeListBuilder.create().texOffs(0, 32).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(0, 44).addBox(-5.0f, -4.0f, 0.0f, 10.0f, 8.0f, 12.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)11.0f, (float)3.0f));
        PartDefinition leg0 = partdefinition.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(32, 32).addBox(-13.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)11.0f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)-0.7854f));
        leg0.addOrReplaceChild("foot0", CubeListBuilder.create().texOffs(32, 37).addBox(-7.0f, 0.0f, -1.0f, 7.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-13.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)-1.0472f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(32, 32).addBox(-1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.0f, (float)11.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.7854f));
        leg1.addOrReplaceChild("foot1", CubeListBuilder.create().texOffs(32, 37).addBox(0.0f, 0.0f, -1.0f, 7.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)13.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)1.0472f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(32, 32).addBox(-13.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)11.0f, (float)1.0f, (float)0.0f, (float)0.2618f, (float)-0.6109f));
        leg2.addOrReplaceChild("foot2", CubeListBuilder.create().texOffs(32, 37).addBox(-7.0f, 0.0f, -1.0f, 7.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-13.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(32, 32).addBox(-1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.0f, (float)11.0f, (float)1.0f, (float)0.0f, (float)-0.2618f, (float)0.6109f));
        leg3.addOrReplaceChild("foot3", CubeListBuilder.create().texOffs(32, 37).addBox(0.0f, 0.0f, -1.0f, 7.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)13.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f));
        PartDefinition leg4 = partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(32, 32).addBox(-13.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)-0.6109f));
        leg4.addOrReplaceChild("foot4", CubeListBuilder.create().texOffs(32, 37).addBox(-7.0f, 0.0f, -1.0f, 7.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-13.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        PartDefinition leg5 = partdefinition.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(32, 32).addBox(-1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.6109f));
        leg5.addOrReplaceChild("foot5", CubeListBuilder.create().texOffs(32, 37).addBox(0.0f, 0.0f, -1.0f, 7.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)13.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f));
        PartDefinition leg6 = partdefinition.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(32, 32).addBox(-13.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)11.0f, (float)-1.0f, (float)0.0f, (float)-0.7854f, (float)-0.7854f));
        leg6.addOrReplaceChild("foot6", CubeListBuilder.create().texOffs(32, 37).addBox(-7.0f, 0.0f, -1.0f, 7.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-13.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)-1.0472f));
        PartDefinition leg7 = partdefinition.addOrReplaceChild("leg7", CubeListBuilder.create().texOffs(32, 32).addBox(-1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.0f, (float)11.0f, (float)-1.0f, (float)0.0f, (float)0.7854f, (float)0.7854f));
        leg7.addOrReplaceChild("foot7", CubeListBuilder.create().texOffs(32, 37).addBox(0.0f, 0.0f, -1.0f, 7.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)13.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)1.0472f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.hat, (Object)this.leftArm, (Object)this.rightArm, (Object)this.torso, (Object)this.body0, (Object)this.body1, (Object)this.spiderLeg0, (Object)this.spiderLeg1, (Object)this.spiderLeg2, (Object)this.spiderLeg3, (Object)this.spiderLeg4, (Object[])new ModelPart[]{this.spiderLeg5, this.spiderLeg6, this.spiderLeg7});
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.head.setPos(0.0f, 0.0f, -3.0f);
        this.hat.setPos(0.0f, 0.0f, -3.0f);
        this.body.setPos(0.0f, 24.0f, 0.0f);
        this.torso.setPos(0.0f, 12.0f, -5.0f);
        this.leftArm.setPos(4.0f, 1.0f, -3.0f);
        this.rightArm.setPos(-4.0f, 1.0f, -3.0f);
        float legFrontBackZ = 0.7853982f;
        float legMiddleZ = 0.58119464f;
        this.spiderLeg0.zRot = -0.7853982f;
        this.spiderLeg1.zRot = 0.7853982f;
        this.spiderLeg2.zRot = -0.58119464f;
        this.spiderLeg3.zRot = 0.58119464f;
        this.spiderLeg4.zRot = -0.58119464f;
        this.spiderLeg5.zRot = 0.58119464f;
        this.spiderLeg6.zRot = -0.7853982f;
        this.spiderLeg7.zRot = 0.7853982f;
        float legFrontBackY = 0.7853982f;
        float legMiddleY = 0.3926991f;
        this.spiderLeg0.yRot = 0.7853982f;
        this.spiderLeg1.yRot = -0.7853982f;
        this.spiderLeg2.yRot = 0.3926991f;
        this.spiderLeg3.yRot = -0.3926991f;
        this.spiderLeg4.yRot = -0.3926991f;
        this.spiderLeg5.yRot = 0.3926991f;
        this.spiderLeg6.yRot = -0.7853982f;
        this.spiderLeg7.yRot = 0.7853982f;
        float leg12Y = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbSwingAmount;
        float leg34Y = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float leg56Y = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float leg78Y = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float leg12Z = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 0.0f)) * 0.4f) * limbSwingAmount;
        float leg34Z = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float leg56Z = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float leg78Z = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 4.712389f)) * 0.4f) * limbSwingAmount;
        this.spiderLeg0.yRot += leg12Y;
        this.spiderLeg1.yRot += -leg12Y;
        this.spiderLeg2.yRot += leg34Y;
        this.spiderLeg3.yRot += -leg34Y;
        this.spiderLeg4.yRot += leg56Y;
        this.spiderLeg5.yRot += -leg56Y;
        this.spiderLeg6.yRot += leg78Y;
        this.spiderLeg7.yRot += -leg78Y;
        this.spiderLeg0.zRot += leg12Z;
        this.spiderLeg1.zRot += -leg12Z;
        this.spiderLeg2.zRot += leg34Z;
        this.spiderLeg3.zRot += -leg34Z;
        this.spiderLeg4.zRot += leg56Z;
        this.spiderLeg5.zRot += -leg56Z;
        this.spiderLeg6.zRot += leg78Z;
        this.spiderLeg7.zRot += -leg78Z;
        float footFrontBackZ = 1.0472f;
        float footMiddleZ = 1.0472f;
        this.spiderFoot0.zRot = -1.0472f;
        this.spiderFoot1.zRot = 1.0472f;
        this.spiderFoot2.zRot = -1.0472f;
        this.spiderFoot3.zRot = 1.0472f;
        this.spiderFoot4.zRot = -1.0472f;
        this.spiderFoot5.zRot = 1.0472f;
        this.spiderFoot6.zRot = -1.0472f;
        this.spiderFoot7.zRot = 1.0472f;
        float footFrontBackY = 0.523599f;
        float footMiddleY = 0.0f;
        this.spiderFoot0.yRot = -0.523599f;
        this.spiderFoot1.yRot = 0.523599f;
        this.spiderFoot2.yRot = -0.0f;
        this.spiderFoot3.yRot = 0.0f;
        this.spiderFoot4.yRot = -0.0f;
        this.spiderFoot5.yRot = 0.0f;
        this.spiderFoot6.yRot = 0.523599f;
        this.spiderFoot7.yRot = -0.523599f;
    }
}

