/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import greekfantasy.entity.Automaton;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class AutomatonModel<T extends Automaton>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    public static final ModelLayerLocation AUTOMATON_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"automaton"), "automaton");
    protected final ModelPart root;
    protected final ModelPart head;
    protected final ModelPart body;
    protected final ModelPart upperBody;
    protected final ModelPart upperMiddleBody;
    protected final ModelPart lowerMiddleBody;
    protected final ModelPart lowerBody;
    protected final ModelPart rightArm;
    protected final ModelPart rightUpperArm;
    protected final ModelPart rightMiddleArm;
    protected final ModelPart rightLowerArm;
    protected final ModelPart leftArm;
    protected final ModelPart leftUpperArm;
    protected final ModelPart leftMiddleArm;
    protected final ModelPart leftLowerArm;
    protected final ModelPart rightLeg;
    protected final ModelPart rightUpperLeg;
    protected final ModelPart rightMiddleLeg;
    protected final ModelPart rightLowerLeg;
    protected final ModelPart leftLeg;
    protected final ModelPart leftUpperLeg;
    protected final ModelPart leftMiddleLeg;
    protected final ModelPart leftLowerLeg;

    public AutomatonModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.upperBody = this.body.getChild("upper_body");
        this.upperMiddleBody = this.upperBody.getChild("upper_middle_body");
        this.lowerMiddleBody = this.upperMiddleBody.getChild("lower_middle_body");
        this.lowerBody = this.lowerMiddleBody.getChild("lower_body");
        this.rightArm = root.getChild("right_arm");
        this.rightUpperArm = this.rightArm.getChild("right_upper_arm");
        this.rightMiddleArm = this.rightUpperArm.getChild("right_middle_arm");
        this.rightLowerArm = this.rightMiddleArm.getChild("right_lower_arm");
        this.leftArm = root.getChild("left_arm");
        this.leftUpperArm = this.leftArm.getChild("left_upper_arm");
        this.leftMiddleArm = this.leftUpperArm.getChild("left_middle_arm");
        this.leftLowerArm = this.leftMiddleArm.getChild("left_lower_arm");
        this.rightLeg = root.getChild("right_leg");
        this.rightUpperLeg = this.rightLeg.getChild("right_upper_leg");
        this.rightMiddleLeg = this.rightUpperLeg.getChild("right_middle_leg");
        this.rightLowerLeg = this.rightMiddleLeg.getChild("right_lower_leg");
        this.leftLeg = root.getChild("left_leg");
        this.leftUpperLeg = this.leftLeg.getChild("left_upper_leg");
        this.leftMiddleLeg = this.leftUpperLeg.getChild("left_middle_leg");
        this.leftLowerLeg = this.leftMiddleLeg.getChild("left_lower_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -6.0f, -4.0f, 8.0f, 6.0f, 8.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-11.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(66, 0).addBox(-5.5f, -5.0f, -3.0f, 8.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-9.0f, (float)-10.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition rightUpperArm = rightArm.addOrReplaceChild("right_upper_arm", CubeListBuilder.create().texOffs(66, 11).addBox(-4.0f, -1.0f, -2.5f, 4.0f, 6.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightMiddleArm = rightUpperArm.addOrReplaceChild("right_middle_arm", CubeListBuilder.create().texOffs(66, 23).addBox(-5.0f, 0.0f, -3.5f, 5.0f, 6.0f, 7.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition rightLowerArm = rightMiddleArm.addOrReplaceChild("right_lower_arm", CubeListBuilder.create().texOffs(64, 37).addBox(-6.0f, 0.0f, -4.5f, 7.0f, 8.0f, 9.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(66, 0).addBox(-2.5f, -5.0f, -3.0f, 8.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)9.0f, (float)-10.0f, (float)0.0f));
        PartDefinition leftUpperArm = leftArm.addOrReplaceChild("left_upper_arm", CubeListBuilder.create().texOffs(66, 11).addBox(0.0f, -1.0f, -2.5f, 4.0f, 6.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftMiddleArm = leftUpperArm.addOrReplaceChild("left_middle_arm", CubeListBuilder.create().texOffs(66, 23).addBox(0.0f, 0.0f, -3.5f, 5.0f, 6.0f, 7.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition leftLowerArm = leftMiddleArm.addOrReplaceChild("left_lower_arm", CubeListBuilder.create().texOffs(96, 37).addBox(-1.0f, 0.0f, -4.5f, 7.0f, 8.0f, 9.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition upperBody = body.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(0, 15).addBox(-9.0f, 0.0f, -5.0f, 18.0f, 8.0f, 11.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition upperMiddleBody = upperBody.addOrReplaceChild("upper_middle_body", CubeListBuilder.create().texOffs(0, 35).addBox(-7.0f, 0.0f, -4.5f, 14.0f, 5.0f, 10.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition lowerMiddleBody = upperMiddleBody.addOrReplaceChild("lower_middle_body", CubeListBuilder.create().texOffs(0, 51).addBox(-5.0f, 0.0f, -4.0f, 10.0f, 4.0f, 9.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition lowerBody = lowerMiddleBody.addOrReplaceChild("lower_body", CubeListBuilder.create().texOffs(39, 53).addBox(-3.0f, 0.0f, -2.5f, 6.0f, 5.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)9.0f, (float)0.5f));
        PartDefinition rightUpperLeg = rightLeg.addOrReplaceChild("right_upper_leg", CubeListBuilder.create().texOffs(103, 0).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightMiddleLeg = rightUpperLeg.addOrReplaceChild("right_middle_leg", CubeListBuilder.create().texOffs(103, 11).addBox(-4.5f, 0.0f, -2.5f, 5.0f, 6.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition rightLowerLeg = rightMiddleLeg.addOrReplaceChild("right_lower_leg", CubeListBuilder.create().texOffs(103, 23).addBox(-5.0f, 0.0f, -3.0f, 6.0f, 5.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)9.0f, (float)0.5f));
        PartDefinition leftUpperLeg = leftLeg.addOrReplaceChild("left_upper_leg", CubeListBuilder.create().texOffs(103, 0).addBox(0.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftMiddleLeg = leftUpperLeg.addOrReplaceChild("left_middle_leg", CubeListBuilder.create().texOffs(103, 11).addBox(-0.5f, 0.0f, -2.5f, 5.0f, 6.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition leftLowerLeg = leftMiddleLeg.addOrReplaceChild("left_lower_leg", CubeListBuilder.create().texOffs(103, 23).addBox(-1.0f, 0.0f, -3.0f, 6.0f, 5.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        if (((Automaton)entity).getAttackTimer() > 0) {
            float attackingPercent = ((Automaton)entity).getAttackPercent(partialTick);
            this.leftArm.xRot = -1.5f * (Mth.sin((float)(attackingPercent * (float)Math.PI)) * 0.5f + 0.5f);
        } else {
            this.leftArm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)limbSwing, (float)10.0f)) * limbSwingAmount;
        }
        this.rightArm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)limbSwing, (float)10.0f)) * limbSwingAmount;
        this.rightArm.xRot += ((Automaton)entity).getShootAnglePercent(partialTick) * ((Automaton)entity).getMaxShootingAngle();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float armPercentAmount = 0.32f;
        float bodyPercentAmount = 0.32f;
        float legPercentAmount = 0.32f;
        float spawnPercentRaw = ((Automaton)entity).getSpawnPercent(ageInTicks - (float)((Automaton)entity).tickCount);
        float spawnPercent = 1.04f - spawnPercentRaw;
        float armPercent = Mth.clamp((float)spawnPercent, (float)0.0f, (float)0.32f) * 3.125f;
        float bodyPercent = Mth.clamp((float)(spawnPercent - 0.32f), (float)0.0f, (float)0.32f) * 3.125f;
        float legPercent = Mth.clamp((float)(spawnPercent - 0.32f - 0.32f), (float)0.0f, (float)0.32f) * 3.125f;
        this.head.setPos(0.0f, -11.0f + 16.01f * bodyPercent + 12.0f * legPercent, 0.0f);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180) * spawnPercentRaw;
        this.body.setPos(0.0f, 5.0f + 10.0f * bodyPercent + 12.0f * legPercent, 0.0f);
        this.lowerMiddleBody.setPos(0.0f, 5.0f - 5.0f * bodyPercent, 0.0f);
        this.lowerBody.setPos(0.0f, 4.0f - 4.0f * bodyPercent, 0.0f);
        this.rightArm.setPos(-9.0f, -10.0f + 14.01f * bodyPercent + 12.0f * legPercent, 0.0f);
        this.rightUpperArm.setPos(0.0f, 0.0f - 3.99f * armPercent, 0.0f);
        this.rightMiddleArm.setPos(0.0f, 5.0f - 5.99f * armPercent, 0.0f);
        this.rightLowerArm.setPos(0.0f, 6.0f - 5.99f * armPercent, 0.0f);
        this.leftArm.setPos(9.0f, -10.0f + 14.01f * bodyPercent + 12.0f * legPercent, 0.0f);
        this.leftUpperArm.setPos(0.0f, 0.0f - 3.99f * armPercent, 0.0f);
        this.leftMiddleArm.setPos(0.0f, 5.0f - 5.99f * armPercent, 0.0f);
        this.leftLowerArm.setPos(0.0f, 6.0f - 5.99f * armPercent, 0.0f);
        this.leftLeg.setPos(3.0f, 9.0f + 12.0f * legPercent, 0.5f);
        this.leftMiddleLeg.setPos(0.0f, 4.0f - 6.0f * legPercent, 0.0f);
        this.leftLowerLeg.setPos(0.0f, 6.0f - 6.0f * legPercent, 0.0f);
        this.rightLeg.setPos(-3.0f, 9.0f + 12.0f * legPercent, 0.5f);
        this.rightMiddleLeg.setPos(0.0f, 4.0f - 6.0f * legPercent, 0.0f);
        this.rightLowerLeg.setPos(0.0f, 6.0f - 6.0f * legPercent, 0.0f);
        this.rightLeg.xRot = -1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftLeg.xRot = 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
    }

    public ModelPart root() {
        return this.root;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void translateToHand(HumanoidArm humanoidArm, PoseStack poseStack) {
        float dX = humanoidArm == HumanoidArm.RIGHT ? -2.0f : 2.0f;
        float dZ = -3.5f;
        float dY = 3.0f;
        ModelPart armModel = this.getArm(humanoidArm);
        armModel.x += dX;
        armModel.y += dY;
        armModel.z += dZ;
        armModel.translateAndRotate(poseStack);
        armModel.x -= dX;
        armModel.y -= dY;
        armModel.z -= dZ;
    }

    protected ModelPart getArm(HumanoidArm humanoidArm) {
        return humanoidArm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }
}

