/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;

public abstract class BigCatModel<T extends LivingEntity>
extends QuadrupedModel<T> {
    protected final ModelPart upperTail;
    protected final ModelPart lowerTail;
    protected final Vector3f headPoints;

    public BigCatModel(ModelPart root) {
        super(root, false, 10.0f, 4.0f, 2.0f, 2.0f, 24);
        this.upperTail = root.getChild("upper_tail");
        this.lowerTail = this.upperTail.getChild("lower_tail");
        this.headPoints = new Vector3f(this.head.x, this.head.y, this.head.z);
    }

    public static MeshDefinition createBodyMesh(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = QuadrupedModel.createBodyMesh((int)0, (CubeDeformation)cubeDeformation);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(29, 0).addBox(-4.0f, -17.0f, -3.0f, 8.0f, 11.0f, 7.0f, cubeDeformation).texOffs(35, 19).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 8.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)8.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.0f, -3.0f, 7.0f, 7.0f, 6.0f, cubeDeformation).texOffs(0, 13).addBox(-2.5f, 1.0f, -5.0f, 5.0f, 4.0f, 2.0f, cubeDeformation).texOffs(21, 1).addBox(-3.5f, -5.0f, -2.0f, 2.0f, 2.0f, 1.0f, cubeDeformation).texOffs(21, 1).mirror().addBox(1.5f, -5.0f, -2.0f, 2.0f, 2.0f, 1.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)10.5f, (float)-10.0f));
        PartDefinition upperTail = partdefinition.addOrReplaceChild("upper_tail", CubeListBuilder.create().texOffs(42, 35).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 5.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)10.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        upperTail.addOrReplaceChild("lower_tail", CubeListBuilder.create().texOffs(47, 35).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 1.0f, cubeDeformation).texOffs(42, 42).addBox(-1.0f, 3.0f, -0.5f, 2.0f, 4.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 19).addBox(-1.5f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDeformation).texOffs(18, 19).addBox(-1.0f, 5.0f, -1.5f, 3.0f, 5.0f, 3.0f, cubeDeformation), PartPose.offset((float)-3.0f, (float)14.0f, (float)-5.0f));
        rightFrontLeg.addOrReplaceChild("right_front_claws", CubeListBuilder.create().texOffs(0, 29).addBox(-1.75f, 0.0f, 0.0f, 3.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)1.0f, (float)9.0f, (float)-1.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 19).addBox(-0.5f, 0.0f, -2.0f, 3.0f, 5.0f, 4.0f, cubeDeformation).texOffs(18, 19).addBox(-0.5f, 5.0f, -1.5f, 3.0f, 5.0f, 3.0f, cubeDeformation), PartPose.offset((float)-3.0f, (float)14.0f, (float)7.0f));
        rightHindLeg.addOrReplaceChild("right_hind_claws", CubeListBuilder.create().texOffs(0, 29).addBox(-1.25f, 0.0f, 0.0f, 3.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)1.0f, (float)9.0f, (float)-1.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg = partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 19).addBox(-2.5f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, cubeDeformation).texOffs(18, 19).addBox(-2.0f, 5.0f, -1.5f, 3.0f, 5.0f, 3.0f, cubeDeformation), PartPose.offset((float)3.0f, (float)14.0f, (float)-5.0f));
        leftFrontLeg.addOrReplaceChild("left_front_claws", CubeListBuilder.create().texOffs(0, 29).addBox(-1.75f, 0.0f, 0.0f, 3.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-1.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindLeg = partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 19).addBox(-2.5f, 0.0f, -2.0f, 3.0f, 5.0f, 4.0f, cubeDeformation).texOffs(18, 19).addBox(-2.5f, 5.0f, -1.5f, 3.0f, 5.0f, 3.0f, cubeDeformation), PartPose.offset((float)3.0f, (float)14.0f, (float)7.0f));
        leftHindLeg.addOrReplaceChild("left_hind_claws", CubeListBuilder.create().texOffs(0, 29).addBox(-1.25f, 0.0f, 0.0f, 3.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)-1.0f, (float)9.0f, (float)-1.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return meshdefinition;
    }

    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat((Iterable)super.bodyParts(), (Iterable)ImmutableList.of((Object)this.upperTail));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float partialTick = ageInTicks - (float)((LivingEntity)entity).tickCount;
        float sittingPercent = this.getSittingPercent(entity, partialTick);
        float sittingPercentLeft = 1.0f - sittingPercent;
        float attackingPercent = this.getAttackingPercent(entity, partialTick);
        float attackingPercentLeft = 1.0f - attackingPercent;
        this.body.setPos(0.0f, 12.0f + 10.0f * sittingPercent, 8.0f - 1.0f * sittingPercent);
        float headX = this.headPoints.x();
        float headY = this.headPoints.y() + 1.0f * sittingPercent - 10.0f * attackingPercent + 2.0f * attackingPercent * sittingPercent;
        float headZ = this.headPoints.z() + 2.0f * sittingPercent + 3.0f * attackingPercent + 4.0f * attackingPercent * sittingPercent;
        this.headParts().forEach(m -> m.setPos(headX, headY, headZ));
        this.leftFrontLeg.setPos(3.0f, 14.0f - 7.0f * attackingPercent + 4.0f * attackingPercent * sittingPercent, -5.0f + 1.0f * attackingPercent + 3.0f * attackingPercent * sittingPercent);
        this.rightFrontLeg.setPos(-3.0f, this.leftFrontLeg.y, this.leftFrontLeg.z);
        this.leftHindLeg.setPos(3.0f, 14.0f + 8.0f * sittingPercent, 7.0f + 1.0f * sittingPercent);
        this.rightHindLeg.setPos(-3.0f, this.leftHindLeg.y, this.leftHindLeg.z);
        this.upperTail.setPos(0.0f, 10.0f + 12.0f * sittingPercent + 1.0f * attackingPercent, 10.0f - 2.0f * sittingPercent + 1.0f * attackingPercent);
        this.head.xRot = attackingPercentLeft * this.head.xRot - 0.34f * attackingPercent;
        this.body.xRot = 1.5708f - 0.5236f * sittingPercent - 0.56f * attackingPercent;
        this.leftFrontLeg.xRot = attackingPercentLeft * this.leftFrontLeg.xRot - 1.52f * attackingPercent;
        this.rightFrontLeg.xRot = attackingPercentLeft * this.rightFrontLeg.xRot - 1.52f * attackingPercent;
        this.leftHindLeg.xRot = sittingPercentLeft * this.leftHindLeg.xRot - 1.4708f * sittingPercent;
        this.rightHindLeg.xRot = sittingPercentLeft * this.rightHindLeg.xRot - 1.4708f * sittingPercent;
        this.leftHindLeg.yRot = 0.0f - 0.2f * sittingPercent;
        this.rightHindLeg.yRot = -this.leftHindLeg.yRot;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float limbSwingCos = Mth.cos((float)limbSwing) * limbSwingAmount;
        float idleSwing = 0.1f * Mth.cos((float)(((float)((LivingEntity)entity).tickCount + partialTick) * 0.08f));
        float tailSwing = 0.42f * limbSwingCos;
        this.upperTail.xRot = 0.6854f + tailSwing + 0.7f * this.getSittingPercent(entity, partialTick);
        this.lowerTail.xRot = 0.3491f + tailSwing * 0.6f;
        this.upperTail.zRot = idleSwing;
        this.lowerTail.zRot = idleSwing * 0.85f;
        this.body.zRot = limbSwingCos * 0.12f;
    }

    protected abstract float getAttackingPercent(T var1, float var2);

    protected abstract float getSittingPercent(T var1, float var2);
}

