/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import greekfantasy.entity.boss.BronzeBull;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BronzeBullModel<T extends BronzeBull>
extends QuadrupedModel<T> {
    public static final ModelLayerLocation BULL_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"bull"), "bull");
    protected final ModelPart mouth;
    protected final ModelPart upperTail;
    protected final ModelPart lowerTail;

    public BronzeBullModel(ModelPart root) {
        super(root, false, 10.0f, 4.0f, 2.0f, 2.0f, 24);
        this.mouth = this.head.getChild("mouth");
        this.upperTail = root.getChild("upper_tail");
        this.lowerTail = this.upperTail.getChild("lower_tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -5.0f, -8.0f, 10.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(29, 0).addBox(-3.0f, 2.0f, -10.0f, 6.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-13.0f));
        head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(47, 28).addBox(-3.0f, 0.0f, -8.0f, 6.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 21).addBox(-7.0f, -15.0f, -4.0f, 14.0f, 16.0f, 18.0f, new CubeDeformation(0.0f)).texOffs(65, 26).addBox(-6.0f, 1.0f, -4.0f, 12.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftLowerHorn = head.addOrReplaceChild("left_lower_horn", CubeListBuilder.create().texOffs(47, 17).addBox(-1.0f, -6.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-3.0f, (float)-5.0f, (float)1.3963f, (float)-1.0472f, (float)0.0f));
        PartDefinition leftMiddleHorn = leftLowerHorn.addOrReplaceChild("left_middle_horn", CubeListBuilder.create().texOffs(48, 8).addBox(-2.01f, -5.0f, 0.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-6.0f, (float)-2.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftUpperHorn = leftMiddleHorn.addOrReplaceChild("left_upper_horn", CubeListBuilder.create().texOffs(49, 0).addBox(-1.5f, -5.0f, 0.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightLowerHorn = head.addOrReplaceChild("right_lower_horn", CubeListBuilder.create().texOffs(47, 17).addBox(-2.0f, -6.0f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-3.0f, (float)-5.0f, (float)1.3963f, (float)1.0472f, (float)0.0f));
        PartDefinition rightMiddleHorn = rightLowerHorn.addOrReplaceChild("right_middle_horn", CubeListBuilder.create().texOffs(48, 8).addBox(-2.99f, -5.0f, 0.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-6.0f, (float)-2.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightUpperHorn = rightMiddleHorn.addOrReplaceChild("right_upper_horn", CubeListBuilder.create().texOffs(49, 0).addBox(-1.5f, -5.0f, 0.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-5.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(91, 0).mirror().addBox(-2.0f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-6.0f, (float)6.0f, (float)12.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(91, 0).addBox(-4.0f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)6.0f, (float)12.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(62, 0).mirror().addBox(-2.0f, 0.0f, -3.0f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-7.0f, (float)6.0f, (float)-8.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(62, 0).addBox(-5.0f, 0.0f, -3.0f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)6.0f, (float)-8.0f));
        PartDefinition upperTail = partdefinition.addOrReplaceChild("upper_tail", CubeListBuilder.create().texOffs(116, 0).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)16.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        upperTail.addOrReplaceChild("lower_tail", CubeListBuilder.create().texOffs(116, 11).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(116, 20).addBox(-1.5f, 3.0f, -0.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat((Iterable)super.bodyParts(), (Iterable)ImmutableList.of((Object)this.upperTail));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float goringPercent = ((BronzeBull)entity).getGoringPercent(ageInTicks - (float)((BronzeBull)entity).tickCount);
        this.body.xRot = 1.5708f + 0.25f * Math.max(goringPercent, 0.4f);
        if (goringPercent > 0.0f) {
            this.head.xRot += 0.5f;
            this.head.yRot += Mth.cos((float)(goringPercent * (float)Math.PI * 10.0f)) * 0.4f;
            this.body.setPos(0.0f, 7.0f, 2.0f);
            this.head.setPos(0.0f, 0.0f, -16.0f);
            this.upperTail.setPos(0.0f, -8.0f, 13.0f);
        } else {
            this.body.setPos(0.0f, 5.0f, 2.0f);
            this.head.setPos(0.0f, -3.0f, -13.0f);
            this.upperTail.setPos(0.0f, -6.0f, 16.0f);
            this.head.zRot = 0.0f;
            this.head.yRot = 0.0f;
            this.body.xRot = 1.5708f;
        }
        float firingPercent = ((BronzeBull)entity).getFiringPercent(1.0f);
        this.mouth.xRot = firingPercent > 0.0f ? 0.56f : 0.0f;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float goringPercent = ((BronzeBull)entity).getGoringPercent(partialTick);
        this.head.zRot = Mth.cos((float)(goringPercent * (float)Math.PI * 16.0f)) * 0.44f;
        float limbSwingCos = Mth.cos((float)limbSwing) * limbSwingAmount;
        float idleSwing = 0.1f * Mth.cos((float)(((float)((BronzeBull)entity).tickCount + partialTick) * 0.08f));
        float tailSwing = 0.42f * limbSwingCos;
        this.upperTail.xRot = 0.5236f + tailSwing;
        this.lowerTail.xRot = 0.2618f + tailSwing * 0.6f;
        this.upperTail.zRot = idleSwing;
        this.lowerTail.zRot = idleSwing * 0.85f;
        this.body.zRot = limbSwingCos * 0.08f;
    }
}

