/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.entity.util.HasHorseVariant;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class CentaurModel<T extends Mob>
extends HumanoidModel<T> {
    public static final ModelLayerLocation CENTAUR_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"centaur"), "centaur");
    protected final ModelPart quiver;

    public CentaurModel(ModelPart root) {
        super(root);
        this.quiver = root.getChild("quiver");
        this.rightLeg.visible = false;
        this.leftLeg.visible = false;
        this.quiver.visible = false;
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, float offset) {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)cubeDeformation, (float)offset);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, -9.0f, -10.0f, 8.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)(0.0f + offset), (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)(-9.0f + offset), (float)-8.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation.extend(0.5f)), PartPose.offset((float)0.0f, (float)(0.0f + offset), (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(0.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)4.0f, (float)(-8.0f + offset), (float)-8.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-4.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)-4.0f, (float)(-8.0f + offset), (float)-8.0f));
        PartDefinition quiver = partdefinition.addOrReplaceChild("quiver", CubeListBuilder.create().texOffs(48, 0).addBox(-2.0f, -5.0f, -2.0f, 4.0f, 10.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)(-4.0f + offset), (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition arrows = quiver.addOrReplaceChild("arrows", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition arrow1 = arrows.addOrReplaceChild("arrow1", CubeListBuilder.create().texOffs(27, 0).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 1.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)(-2.0f + offset), (float)0.0f));
        PartDefinition arrow2 = arrows.addOrReplaceChild("arrow2", CubeListBuilder.create().texOffs(27, 0).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)(-2.0f + offset), (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return meshdefinition;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = CentaurModel.createMesh(CubeDeformation.NONE, 0.0f);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.hat);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch) {
        ItemStack item = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (item.getItem() instanceof BowItem && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        } else {
            this.rightArmPose = this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        }
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch);
        float rearingTime = ((HasHorseVariant)entity).getRearingAmount(ageInTicks - (float)Math.floor(ageInTicks));
        float rearingTimeLeft = 1.0f - rearingTime;
        this.body.setPos(0.0f, -6.0f * rearingTime, 10.0f * rearingTime - 1.0f * rearingTimeLeft);
        this.head.setPos(0.0f, -15.0f * rearingTime - 9.0f * rearingTimeLeft, 2.0f * rearingTime - 9.0f * rearingTimeLeft);
        this.hat.setPos(this.head.x, this.head.y, this.head.z);
        this.leftArm.setPos(4.0f, -14.0f * rearingTime - 8.0f * rearingTimeLeft, 2.0f * rearingTime - 9.0f * rearingTimeLeft);
        this.rightArm.setPos(-4.0f, this.leftArm.y, this.leftArm.z);
        this.quiver.setPos(0.0f, -9.0f * rearingTime - 3.0f * rearingTimeLeft, 6.5f * rearingTime - 5.0f * rearingTimeLeft);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
    }

    public void renderQuiver(T entity, PoseStack matrixStackIn, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float limbSwing, float limbSwingAmount) {
        this.quiver.visible = true;
        this.body.render(matrixStackIn, vertexConsumer, packedLight, packedOverlay);
        this.quiver.render(matrixStackIn, vertexConsumer, packedLight, packedOverlay);
    }
}

