/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import greekfantasy.client.entity.model.GFModelUtil;
import greekfantasy.entity.Cerastes;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CerastesModel<T extends Cerastes>
extends AgeableListModel<T> {
    public static final ModelLayerLocation CERASTES_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"cerastes"), "cerastes");
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart tongue;
    private final ModelPart body1;
    private final ModelPart body2;
    private final ModelPart body3;
    private final ModelPart body4;
    private final ModelPart body5;
    private final ModelPart body6;
    private final ModelPart body7;

    public CerastesModel(ModelPart root) {
        this.head = root.getChild("head");
        this.mouth = this.head.getChild("mouth");
        this.tongue = this.mouth.getChild("tongue");
        this.body1 = root.getChild("body1");
        this.body2 = this.body1.getChild("body2");
        this.body3 = this.body2.getChild("body3");
        this.body4 = this.body3.getChild("body4");
        this.body5 = this.body4.getChild("body5");
        this.body6 = this.body5.getChild("body6");
        this.body7 = this.body6.getChild("body7");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -6.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.NONE).texOffs(25, 0).addBox(-2.0f, -1.0f, -10.0f, 4.0f, 2.0f, 4.0f, CubeDeformation.NONE).texOffs(43, 6).addBox(-1.5f, 0.75f, -9.5f, 3.0f, 1.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)10.0f, (float)-4.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(25, 7).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 1.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-6.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tongue = mouth.addOrReplaceChild("tongue", CubeListBuilder.create().texOffs(42, 0).addBox(-0.5f, -0.9f, -4.0f, 1.0f, 1.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("left_nub", CubeListBuilder.create().texOffs(59, 13).addBox(0.0f, -4.0f, -1.0f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)-4.0f, (float)-4.0f, (float)0.48f, (float)0.0f, (float)0.1745f));
        head.addOrReplaceChild("right_nub", CubeListBuilder.create().texOffs(59, 13).addBox(-1.0f, -4.0f, -1.0f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.0f, (float)-4.0f, (float)-4.0f, (float)0.48f, (float)0.0f, (float)-0.1745f));
        GFModelUtil.addOrReplaceRamHorn(head, "left_horn", 3.0f, -2.0f, -4.0f, true);
        GFModelUtil.addOrReplaceRamHorn(head, "right_horn", -3.0f, -2.0f, -4.0f, false);
        PartDefinition body1 = partdefinition.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(0, 13).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-4.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = body1.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(0, 13).addBox(-1.99f, 0.0f, 0.0f, 4.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)6.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition body3 = body2.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(0, 13).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)6.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition body4 = body3.addOrReplaceChild("body4", CubeListBuilder.create().texOffs(0, 13).addBox(-1.99f, -4.0f, 0.0f, 4.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)6.0f, (float)0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition body5 = body4.addOrReplaceChild("body5", CubeListBuilder.create().texOffs(0, 13).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)5.5f));
        PartDefinition body6 = body5.addOrReplaceChild("body6", CubeListBuilder.create().texOffs(21, 14).addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)5.5f));
        PartDefinition body7 = body6.addOrReplaceChild("body7", CubeListBuilder.create().texOffs(22, 14).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)5.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch) {
        float partialTick = ageInTicks - (float)((Cerastes)((Object)entity)).tickCount;
        float standingTime = ((Cerastes)((Object)entity)).getStandingPercent(partialTick);
        float standingTimeLeft = 1.0f - standingTime;
        float hidingTime = ((Cerastes)((Object)entity)).getHidingPercent(partialTick);
        float limbSwingCos = ((Cerastes)((Object)entity)).isHiding() ? 1.0f : Mth.cos((float)limbSwing);
        float idleSwingCos = Mth.cos((float)(((float)((Cerastes)((Object)entity)).tickCount + partialTick) * 0.22f));
        this.head.y = 21.5f - 10.25f * standingTime + 6.5f * hidingTime;
        this.head.z = -6.0f + 6.0f * hidingTime;
        this.body1.y = this.head.y - 2.0f;
        this.body1.z = this.head.z - 0.5f;
        this.head.yRot = rotationYaw * ((float)Math.PI / 180);
        this.head.xRot = rotationPitch * ((float)Math.PI / 180);
        this.tongue.z = -4.0f * (1.0f - 2.0f * Math.abs(((Cerastes)((Object)entity)).getTonguePercent(partialTick) - 0.5f));
        this.body1.xRot = -0.7854f * standingTime - 1.4707f * hidingTime;
        this.body2.xRot = -0.5236f * standingTime;
        this.body3.xRot = 0.3491f * standingTime;
        this.body4.xRot = 0.9599f * standingTime;
        this.mouth.xRot = (0.5236f + 0.06f * idleSwingCos) * standingTime;
        if (entity.isInSittingPose()) {
            this.body5.yRot = 0.761799f;
            this.body6.yRot = 0.761799f;
            this.body7.yRot = 0.761799f;
        } else {
            this.body1.yRot = limbSwingCos * -0.4f * standingTimeLeft;
            this.body2.yRot = limbSwingCos * 0.4f * standingTimeLeft;
            this.body3.yRot = limbSwingCos * -0.65f * standingTimeLeft;
            this.body4.yRot = limbSwingCos * 0.75f * standingTimeLeft;
            this.body5.yRot = limbSwingCos * -0.65f;
            this.body6.yRot = limbSwingCos * 0.65f;
            this.body7.yRot = limbSwingCos * -0.25f;
        }
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body1);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }
}

