/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.client.entity.model.GFModelUtil;
import greekfantasy.entity.boss.Cerberus;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CerberusModel<T extends Cerberus>
extends AgeableListModel<T> {
    public static final ModelLayerLocation CERBERUS_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"cerberus"), "cerberus");
    private final ModelPart body;
    private final ModelPart middleNeck;
    private final ModelPart middleHead;
    private final ModelPart middleMouth;
    private final ModelPart rightNeck;
    private final ModelPart rightHead;
    private final ModelPart rightMouth;
    private final ModelPart leftNeck;
    private final ModelPart leftHead;
    private final ModelPart leftMouth;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart upperTail;
    private final ModelPart lowerTail;
    float color = 1.0f;

    public CerberusModel(ModelPart root) {
        this.body = root.getChild("body");
        this.middleNeck = root.getChild("middle_neck");
        this.middleHead = this.middleNeck.getChild("middle_head");
        this.middleMouth = this.middleHead.getChild("mouth");
        this.leftNeck = root.getChild("left_neck");
        this.leftHead = this.leftNeck.getChild("left_head");
        this.leftMouth = this.leftHead.getChild("mouth");
        this.rightNeck = root.getChild("right_neck");
        this.rightHead = this.rightNeck.getChild("right_head");
        this.rightMouth = this.rightHead.getChild("mouth");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.upperTail = root.getChild("upper_tail");
        this.lowerTail = this.upperTail.getChild("lower_tail");
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.middleNeck, (Object)this.rightNeck, (Object)this.leftNeck);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.upperTail);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 29).addBox(-5.0f, -18.0f, -6.0f, 10.0f, 8.0f, 6.0f, CubeDeformation.NONE).texOffs(0, 12).addBox(-4.0f, -17.0f, 0.0f, 8.0f, 7.0f, 9.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition middleNeck = partdefinition.addOrReplaceChild("middle_neck", CubeListBuilder.create().texOffs(50, 18).addBox(-1.5f, -4.0f, -3.0f, 3.0f, 4.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        GFModelUtil.addOrReplaceCerberusHead(middleNeck, "middle_head", 0.0f, -4.0f, -3.0f, 0.0f);
        PartDefinition leftNeck = partdefinition.addOrReplaceChild("left_neck", CubeListBuilder.create().texOffs(50, 17).addBox(-2.0f, -4.0f, -3.0f, 3.0f, 4.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.0f, (float)14.0f, (float)-5.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        GFModelUtil.addOrReplaceCerberusHead(leftNeck, "left_head", 0.0f, -4.0f, -3.0f, -0.5f);
        PartDefinition rightNeck = partdefinition.addOrReplaceChild("right_neck", CubeListBuilder.create().texOffs(50, 17).addBox(-1.0f, -4.0f, -3.0f, 3.0f, 4.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)14.0f, (float)-5.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        GFModelUtil.addOrReplaceCerberusHead(rightNeck, "right_head", 0.0f, -4.0f, -3.0f, 0.5f);
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(37, 0).addBox(-1.0f, 4.0f, -2.0f, 3.0f, 6.0f, 3.0f, CubeDeformation.NONE).texOffs(33, 10).addBox(-1.5f, -2.0f, -2.5f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-3.0f, (float)14.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(37, 0).addBox(-1.0f, 4.0f, -2.0f, 3.0f, 6.0f, 3.0f, CubeDeformation.NONE).texOffs(33, 10).addBox(-1.5f, -2.0f, -2.5f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-3.0f, (float)14.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(37, 0).addBox(-2.0f, 4.0f, -2.0f, 3.0f, 6.0f, 3.0f, CubeDeformation.NONE).texOffs(33, 10).addBox(-2.5f, -2.0f, -2.5f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)3.0f, (float)14.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(37, 0).addBox(-2.0f, 4.0f, -2.0f, 3.0f, 6.0f, 3.0f, CubeDeformation.NONE).texOffs(33, 10).addBox(-2.5f, -2.0f, -2.5f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)3.0f, (float)14.0f, (float)7.0f));
        PartDefinition upperTail = partdefinition.addOrReplaceChild("upper_tail", CubeListBuilder.create().texOffs(50, 0).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)9.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        upperTail.addOrReplaceChild("lower_tail", CubeListBuilder.create().texOffs(50, 8).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        float limbSwingCos = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        float limbSwingSin = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        float ticks = (float)((Cerberus)((Object)entity)).tickCount + partialTick;
        float idleSwing = 0.12f * Mth.cos((float)(ticks * 0.11f));
        float tailSwing = 0.42f * limbSwingCos;
        this.upperTail.xRot = 0.5854f + tailSwing;
        this.lowerTail.xRot = 0.2618f + tailSwing * 0.6f;
        this.upperTail.zRot = idleSwing;
        this.lowerTail.zRot = idleSwing * 0.85f;
        float legAngle = 1.2f;
        this.rightHindLeg.xRot = limbSwingCos * 1.2f;
        this.leftHindLeg.xRot = limbSwingSin * 1.2f;
        this.rightFrontLeg.xRot = limbSwingSin * 1.2f;
        this.leftFrontLeg.xRot = limbSwingCos * 1.2f;
        float howlingTimeLeft = 1.0f - ((Cerberus)((Object)entity)).getSummonPercent(partialTick);
        float mouthAngle = 0.26f;
        this.middleMouth.xRot = (0.26f - Mth.cos((float)((ticks + 0.0f) * 0.28f)) * 0.26f * 0.3f) * howlingTimeLeft;
        this.rightMouth.xRot = (0.26f - Mth.cos((float)((ticks + 0.9f) * 0.19f)) * 0.26f * 0.3f) * howlingTimeLeft;
        this.leftMouth.xRot = (0.26f - Mth.cos((float)((ticks + 0.4f) * 0.24f)) * 0.26f * 0.3f) * howlingTimeLeft;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch) {
        float partialTick = ageInTicks - (float)((Cerberus)((Object)entity)).tickCount;
        this.color = ((Cerberus)((Object)entity)).isSpawning() ? ((Cerberus)((Object)entity)).getSpawnPercent(partialTick) : 1.0f;
        float howlingTime = ((Cerberus)((Object)entity)).getSummonPercent(partialTick);
        float howlingTimeLeft = 1.0f - howlingTime;
        float howlingAngle = howlingTime > 0.0f ? -4.0f * (float)Math.pow(2.0f * howlingTime - 1.0f, 2.0) + 5.0f : 1.0f;
        float neckAngleX = 0.1f;
        float neck1X = -0.2618f * howlingAngle + Mth.cos((float)((ageInTicks + 0.1f) * 0.049f)) * 0.1f * howlingTimeLeft;
        float neck2X = -0.1745f * howlingAngle + Mth.cos((float)((ageInTicks + 0.9f) * 0.059f)) * 0.1f * howlingTimeLeft;
        float neck3X = -0.1745f * howlingAngle + Mth.cos((float)((ageInTicks + 1.5f) * 0.055f)) * 0.1f * howlingTimeLeft;
        this.middleNeck.xRot = neck1X;
        this.rightNeck.xRot = neck2X;
        this.leftNeck.xRot = neck3X;
        float offsetX = 0.2309f;
        float pitch = rotationPitch * ((float)Math.PI / 180);
        float yaw = rotationYaw * ((float)Math.PI / 180) * howlingTimeLeft;
        this.middleHead.xRot = (pitch - this.middleNeck.xRot) * howlingTimeLeft;
        this.middleHead.yRot = yaw;
        this.rightHead.xRot = (pitch - this.rightNeck.xRot) * howlingTimeLeft;
        this.rightHead.yRot = yaw * 0.8f - 0.2309f;
        this.leftHead.xRot = (pitch - this.leftNeck.xRot) * howlingTimeLeft;
        this.leftHead.yRot = yaw * 0.8f + 0.2309f;
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, int color) {
        super.renderToBuffer(matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, color);
    }
}

