/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import greekfantasy.client.entity.model.GFModelUtil;
import greekfantasy.entity.boss.Charybdis;
import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CharybdisModel
extends AgeableListModel<Charybdis> {
    public static final ModelLayerLocation CHARYBDIS_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"charybdis"), "charybdis");
    protected final ModelPart body;
    protected final ModelPart upperBody;
    protected final ModelPart upperMiddleBody;
    protected final ModelPart lowerMiddleBody;
    protected final ModelPart lowerBody;
    protected final ModelPart head;
    protected final ModelPart arms;
    protected final List<GFModelUtil.Tuple3<ModelPart>> armList;
    protected final List<ModelPart> upperFringes;
    protected final List<ModelPart> upperMiddleFringes;
    protected final List<ModelPart> lowerMiddleFringes;
    protected final List<ModelPart> lowerFringes;

    public CharybdisModel(ModelPart root) {
        this.head = root.getChild("head");
        this.arms = root.getChild("arms");
        this.armList = GFModelUtil.getCharybdisArmsList(this.arms);
        this.body = root.getChild("body");
        this.upperBody = this.body.getChild("upper_body");
        this.upperMiddleBody = this.body.getChild("upper_middle_body");
        this.lowerMiddleBody = this.body.getChild("lower_middle_body");
        this.lowerBody = this.body.getChild("lower_body");
        this.upperFringes = GFModelUtil.getSingleCharybdisFringeList(this.upperBody);
        this.upperMiddleFringes = GFModelUtil.getTripleCharybdisFringeList(this.upperMiddleBody);
        this.lowerMiddleFringes = GFModelUtil.getTripleCharybdisFringeList(this.lowerMiddleBody);
        this.lowerFringes = GFModelUtil.getSingleCharybdisFringeList(this.lowerBody);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float r0 = 0.0f;
        float r90 = (float)Math.toRadians(90.0);
        float r180 = (float)Math.toRadians(180.0);
        float r270 = (float)Math.toRadians(270.0);
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition upperBody = body.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(0, 0).addBox(-12.0f, -2.0f, -12.0f, 24.0f, 6.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-30.0f, (float)0.0f));
        GFModelUtil.createCharybdisUpperFringe(upperBody, "east_fringe", 0.0f);
        GFModelUtil.createCharybdisUpperFringe(upperBody, "south_fringe", r90);
        GFModelUtil.createCharybdisUpperFringe(upperBody, "west_fringe", r180);
        GFModelUtil.createCharybdisUpperFringe(upperBody, "north_fringe", r270);
        PartDefinition upperMiddleBody = body.addOrReplaceChild("upper_middle_body", CubeListBuilder.create().texOffs(0, 57).addBox(-8.0f, 0.0f, -8.0f, 16.0f, 10.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-26.0f, (float)0.0f));
        GFModelUtil.createCharybdisUpperMiddleFringe(upperMiddleBody, "east_fringe", 0.0f);
        GFModelUtil.createCharybdisUpperMiddleFringe(upperMiddleBody, "south_fringe", r90);
        GFModelUtil.createCharybdisUpperMiddleFringe(upperMiddleBody, "west_fringe", r180);
        GFModelUtil.createCharybdisUpperMiddleFringe(upperMiddleBody, "north_fringe", r270);
        PartDefinition lowerMiddleBody = body.addOrReplaceChild("lower_middle_body", CubeListBuilder.create().texOffs(64, 57).addBox(-5.0f, -16.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        GFModelUtil.createCharybdisLowerMiddleFringe(lowerMiddleBody, "east_fringe", 0.0f);
        GFModelUtil.createCharybdisLowerMiddleFringe(lowerMiddleBody, "south_fringe", r90);
        GFModelUtil.createCharybdisLowerMiddleFringe(lowerMiddleBody, "west_fringe", r180);
        GFModelUtil.createCharybdisLowerMiddleFringe(lowerMiddleBody, "north_fringe", r270);
        PartDefinition lowerBody = body.addOrReplaceChild("lower_body", CubeListBuilder.create().texOffs(104, 57).addBox(-3.0f, -8.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        GFModelUtil.createCharybdisLowerFringe(lowerBody, "east_fringe", 0.0f);
        GFModelUtil.createCharybdisLowerFringe(lowerBody, "south_fringe", r90);
        GFModelUtil.createCharybdisLowerFringe(lowerBody, "west_fringe", r180);
        GFModelUtil.createCharybdisLowerFringe(lowerBody, "north_fringe", r270);
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 30).addBox(-10.0f, -32.01f, -10.0f, 20.0f, 6.0f, 20.0f, new CubeDeformation(0.0f)).texOffs(80, 40).addBox(-6.0f, -26.0f, -6.0f, 12.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        GFModelUtil.createCharybdisTeeth(head, "east_teeth", 0.0f);
        GFModelUtil.createCharybdisTeeth(head, "south_teeth", r90);
        GFModelUtil.createCharybdisTeeth(head, "west_teeth", r180);
        GFModelUtil.createCharybdisTeeth(head, "north_teeth", r270);
        PartDefinition arms = partdefinition.addOrReplaceChild("arms", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        GFModelUtil.createCharybdisArms(arms, "east_arms", 0.0f);
        GFModelUtil.createCharybdisArms(arms, "south_arms", r90);
        GFModelUtil.createCharybdisArms(arms, "west_arms", r180);
        GFModelUtil.createCharybdisArms(arms, "north_arms", r270);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.arms);
    }

    public void setupAnim(Charybdis entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch) {
        this.setupArmAnim(entity, ageInTicks);
        float idleCos = Mth.cos((float)(ageInTicks * 0.064f));
        float cosRot = idleCos * 0.44f;
        for (ModelPart part : this.upperFringes) {
            part.xRot = cosRot;
        }
        cosRot = idleCos * 0.62f;
        for (ModelPart part : this.upperMiddleFringes) {
            part.yRot = cosRot;
        }
        cosRot = idleCos * 0.58f;
        for (ModelPart part : this.lowerMiddleFringes) {
            part.yRot = cosRot;
        }
        cosRot = idleCos * 0.54f;
        for (ModelPart part : this.lowerFringes) {
            part.yRot = cosRot;
        }
    }

    public void setupArmAnim(Charybdis entity, float ageInTicks) {
        float partialTick = ageInTicks - (float)entity.tickCount;
        float swirlingTime = entity.isSwirling() ? entity.getSwirlPercent(partialTick) : 0.0f;
        float throwingTime = entity.isThrowing() ? entity.getThrowPercent(partialTick) : 0.0f;
        float throwingTimeLeft = 1.0f - throwingTime;
        float throwingZ = 0.9f - 2.0f * Math.abs(throwingTime - 0.5f);
        float armAmplitude = 0.25f + swirlingTime * 0.6f;
        int n = this.armList.size();
        for (int i = 0; i < n; ++i) {
            GFModelUtil.Tuple3<ModelPart> arm = this.armList.get(i);
            float idleSwing = Mth.cos((float)(ageInTicks * 0.08f + (float)i * 1.62f)) * armAmplitude;
            GFModelUtil.setupCharybdisArmAnim((ModelPart)arm.left, (ModelPart)arm.middle, (ModelPart)arm.right, idleSwing, throwingTimeLeft, throwingZ);
        }
    }
}

