/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class DrakainaModel<T extends Mob>
extends HumanoidModel<T> {
    public static final ModelLayerLocation DRAKAINA_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"drakaina"), "drakaina");
    protected ModelPart upperTail;
    protected ModelPart midTail;
    protected ModelPart lowerTail;
    protected ModelPart lowerTail1;
    protected ModelPart lowerTail2;
    protected ModelPart lowerTail3;

    public DrakainaModel(ModelPart root) {
        super(root);
        this.upperTail = root.getChild("upper_tail");
        this.midTail = this.upperTail.getChild("mid_tail");
        this.lowerTail = this.midTail.getChild("lower_tail");
        this.lowerTail1 = this.lowerTail.getChild("lower_tail1");
        this.lowerTail2 = this.lowerTail1.getChild("lower_tail2");
        this.lowerTail3 = this.lowerTail2.getChild("lower_tail3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = DrakainaModel.createMesh(CubeDeformation.NONE, 0.0f);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, float offset) {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)cubeDeformation, (float)offset);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)(0.0f + offset), (float)-2.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation.extend(0.25f)), PartPose.offset((float)0.0f, (float)(0.0f + offset), (float)-2.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)(0.0f + offset), (float)0.0f));
        PartDefinition upperTail = partdefinition.addOrReplaceChild("upper_tail", CubeListBuilder.create().texOffs(0, 32).addBox(-3.999f, 0.0f, -4.0f, 8.0f, 10.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)(0.0f + offset), (float)12.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition midTail = upperTail.addOrReplaceChild("mid_tail", CubeListBuilder.create().texOffs(0, 46).addBox(-4.001f, 0.0f, 0.0f, 8.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)(10.0f + offset), (float)-4.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition lowerTail = midTail.addOrReplaceChild("lower_tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition lowerTail1 = lowerTail.addOrReplaceChild("lower_tail1", CubeListBuilder.create().texOffs(25, 32).addBox(-3.0f, -1.0f, 0.0f, 6.0f, 8.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)(2.0f + offset), (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition lowerTail2 = lowerTail1.addOrReplaceChild("lower_tail2", CubeListBuilder.create().texOffs(46, 32).addBox(-2.0f, -1.0f, 0.0f, 4.0f, 8.0f, 3.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)(6.0f + offset), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition lowerTail3 = lowerTail2.addOrReplaceChild("lower_tail3", CubeListBuilder.create().texOffs(46, 43).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 6.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)(7.0f + offset), (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(0.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)4.0f, (float)(2.0f + offset), (float)-2.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)-4.0f, (float)(2.0f + offset), (float)-2.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        return meshdefinition;
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.upperTail, (Object)this.hat);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack item = entity.getMainHandItem();
        if (entity.isAggressive() && item.getItem() instanceof BowItem) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        } else {
            this.rightArmPose = this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        }
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.leftArm.x = 4.0f;
        this.leftArm.z = -2.0f;
        this.rightArm.x = -4.0f;
        this.rightArm.z = -2.0f;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float limbSwingCos = (float)Math.cos(limbSwing);
        this.upperTail.yRot = limbSwingCos * 0.1f;
        this.lowerTail1.zRot = limbSwingCos * 0.67f;
        this.lowerTail2.zRot = limbSwingCos * -0.75f;
        this.lowerTail3.zRot = limbSwingCos * 0.4f;
    }
}

