/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import greekfantasy.entity.Elpis;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class ElpisModel<T extends Elpis>
extends AgeableListModel<T>
implements ArmedModel,
HeadedModel {
    public static final ModelLayerLocation ELPIS_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"elpis"), "elpis");
    protected final ModelPart head;
    protected final ModelPart body;
    protected final ModelPart leftArm;
    protected final ModelPart rightArm;
    protected final ModelPart leftWing;
    protected final ModelPart rightWing;
    protected final ModelPart item;
    protected float alpha;

    public ElpisModel(ModelPart root) {
        super(RenderType::entityTranslucent, false, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftArm = this.body.getChild("left_arm");
        this.rightArm = this.body.getChild("right_arm");
        this.leftWing = this.body.getChild("left_wing");
        this.rightWing = this.body.getChild("right_wing");
        this.item = this.body.getChild("item");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -5.01f, -2.5f, 5.0f, 5.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 10).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, CubeDeformation.NONE).texOffs(0, 16).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        body.addOrReplaceChild("item", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)4.0f, (float)3.5f));
        body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(23, 0).addBox(-0.75f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)-1.75f, (float)0.5f, (float)0.0f));
        body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(23, 6).addBox(-0.25f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)1.75f, (float)0.5f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(14, 14).mirror().addBox(-1.0f, -1.0f, 0.0f, 1.0f, 6.0f, 8.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)1.0f, (float)1.0f, (float)0.43633232f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(14, 14).addBox(0.0f, -1.0f, 0.0f, 1.0f, 6.0f, 8.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.5f, (float)1.0f, (float)1.0f, (float)0.43633232f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        float baseWingY = 0.61086524f;
        float wingY = Mth.cos((float)(ageInTicks * 20.0f * ((float)Math.PI / 180) + limbSwingAmount)) * (float)Math.PI * 0.15f;
        this.leftWing.yRot = baseWingY - wingY;
        this.rightWing.yRot = -baseWingY + wingY;
        if (!entity.getMainHandItem().isEmpty() || !entity.getOffhandItem().isEmpty()) {
            this.rightArm.xRot = -0.7854f;
            this.leftArm.xRot = -0.7854f;
            this.item.xRot = -0.7854f;
        } else {
            this.rightArm.xRot = 0.0f;
            this.leftArm.xRot = 0.0f;
            this.item.xRot = 0.0f;
        }
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.item.zRot = 0.0f;
        AnimationUtils.bobModelPart((ModelPart)this.rightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.bobModelPart((ModelPart)this.leftArm, (float)ageInTicks, (float)-1.0f);
        AnimationUtils.bobModelPart((ModelPart)this.item, (float)ageInTicks, (float)0.5f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        super.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.getHead());
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.body.translateAndRotate(poseStack);
        this.item.translateAndRotate(poseStack);
        poseStack.mulPose(Axis.XP.rotation(-0.5363323f));
        poseStack.scale(0.7f, 0.7f, 0.7f);
    }

    public ModelPart getHead() {
        return this.head;
    }
}

