/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import greekfantasy.entity.monster.Empusa;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class EmpusaModel<T extends Empusa>
extends HumanoidModel<T> {
    public static final ModelLayerLocation EMPUSA_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"empusa"), "empusa");
    private final ModelPart leftWingArm;
    private final ModelPart leftWingInner;
    private final ModelPart leftWingOuter;
    private final ModelPart rightWingArm;
    private final ModelPart rightWingInner;
    private final ModelPart rightWingOuter;

    public EmpusaModel(ModelPart root) {
        super(root);
        this.leftWingArm = root.getChild("left_wing_arm");
        this.leftWingInner = this.leftWingArm.getChild("left_inner_wing");
        this.leftWingOuter = this.leftWingInner.getChild("left_outer_wing");
        this.rightWingArm = root.getChild("right_wing_arm");
        this.rightWingInner = this.rightWingArm.getChild("right_inner_wing");
        this.rightWingOuter = this.rightWingInner.getChild("right_outer_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 32).addBox(-3.99f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_wing_arm = partdefinition.addOrReplaceChild("left_wing_arm", CubeListBuilder.create().texOffs(47, 33).addBox(0.0f, -2.0f, -0.1f, 2.0f, 2.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)4.0f, (float)2.0f, (float)0.0873f, (float)0.3927f, (float)0.0f));
        PartDefinition left_wing_inner = left_wing_arm.addOrReplaceChild("left_inner_wing", CubeListBuilder.create().texOffs(31, 33).addBox(-4.0f, -7.0f, 0.0f, 6.0f, 14.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)3.0f, (float)0.0f, (float)4.0f));
        left_wing_inner.addOrReplaceChild("left_outer_wing", CubeListBuilder.create().texOffs(46, 43).addBox(0.0f, -8.0f, 0.0f, 8.0f, 20.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition right_wing_arm = partdefinition.addOrReplaceChild("right_wing_arm", CubeListBuilder.create().texOffs(47, 33).addBox(-2.0f, -2.0f, -0.1f, 2.0f, 2.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.0f, (float)4.0f, (float)2.0f, (float)0.0873f, (float)-0.3927f, (float)0.0f));
        PartDefinition right_wing_inner = right_wing_arm.addOrReplaceChild("right_inner_wing", CubeListBuilder.create().texOffs(31, 33).mirror().addBox(-3.0f, -7.0f, 0.0f, 6.0f, 14.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-2.0f, (float)0.0f, (float)4.0f));
        right_wing_inner.addOrReplaceChild("right_outer_wing", CubeListBuilder.create().texOffs(46, 43).mirror().addBox(-8.0f, -8.0f, 0.0f, 8.0f, 20.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftWingArm, (Object)this.rightWingArm, (Object)this.leftLeg, (Object)this.rightLeg, (Object)this.hat);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float partialTick, float rotationYaw, float rotationPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, partialTick, rotationYaw, rotationPitch);
        if (((Empusa)((Object)entity)).isDraining()) {
            this.leftArm.xRot = -0.436f;
            this.leftArm.zRot = -0.698f;
            this.rightArm.xRot = -0.436f;
            this.rightArm.zRot = 0.698f;
        }
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float ticks = (float)(entity.getId() * 2 + ((Empusa)((Object)entity)).tickCount) + partialTick;
        float cosTicks = Mth.cos((float)(ticks * 0.1f));
        this.leftWingInner.yRot = cosTicks * 0.035f;
        this.leftWingOuter.yRot = 0.3491f + cosTicks * 0.05f;
        this.rightWingInner.yRot = -cosTicks * 0.035f;
        this.rightWingOuter.yRot = -0.3491f - cosTicks * 0.05f;
    }

    public ModelPart getHeadPart() {
        return this.head;
    }
}

