/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import greekfantasy.client.entity.model.GFModelUtil;
import greekfantasy.entity.monster.Fury;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class FuryModel<T extends Fury>
extends HumanoidModel<T> {
    public static final ModelLayerLocation FURY_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"fury"), "fury");
    protected final ModelPart leftWingArm;
    protected final ModelPart leftWingInner;
    protected final ModelPart leftWingOuter;
    protected final ModelPart rightWingArm;
    protected final ModelPart rightWingInner;
    protected final ModelPart rightWingOuter;
    protected final ModelPart hair;
    protected final ModelPart lowerHair;
    protected final ModelPart middleHair;
    protected final ModelPart upperHair;
    protected final List<ModelPart> lowerSnakes;
    protected final List<ModelPart> middleSnakes;
    protected final List<ModelPart> upperSnakes;

    public FuryModel(ModelPart root) {
        super(root);
        this.leftWingArm = root.getChild("left_wing_arm");
        this.leftWingInner = this.leftWingArm.getChild("left_inner_wing");
        this.leftWingOuter = this.leftWingInner.getChild("left_outer_wing");
        this.rightWingArm = root.getChild("right_wing_arm");
        this.rightWingInner = this.rightWingArm.getChild("right_inner_wing");
        this.rightWingOuter = this.rightWingInner.getChild("right_outer_wing");
        this.hair = root.getChild("hair");
        this.lowerHair = this.hair.getChild("lower_hair");
        this.middleHair = this.hair.getChild("middle_hair");
        this.upperHair = this.hair.getChild("upper_hair");
        this.lowerSnakes = GFModelUtil.getSnakeModelParts(this.lowerHair, 12);
        this.middleSnakes = GFModelUtil.getSnakeModelParts(this.middleHair, 8);
        this.upperSnakes = GFModelUtil.getSnakeModelParts(this.upperHair, 6);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition hair = partdefinition.addOrReplaceChild("hair", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition lowerHair = hair.addOrReplaceChild("lower_hair", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.5f, (float)0.0f));
        PartDefinition middleHair = hair.addOrReplaceChild("middle_hair", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.5f, (float)0.0f));
        PartDefinition upperHair = hair.addOrReplaceChild("upper_hair", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.5f, (float)0.0f));
        GFModelUtil.createSnakeLayers(lowerHair, 3.8f, 0.5235988f, CubeDeformation.NONE, 0, 52);
        GFModelUtil.createSnakeLayers(middleHair, 2.25f, 0.7853982f, CubeDeformation.NONE, 0, 52);
        GFModelUtil.createSnakeLayers(upperHair, 1.25f, 1.0471976f, CubeDeformation.NONE, 0, 52);
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 4.0f, -2.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 32).addBox(-3.99f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-2.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-5.0f, (float)5.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -1.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)5.0f, (float)5.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-1.9f, (float)16.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)1.9f, (float)16.0f, (float)0.0f));
        PartDefinition left_wing_arm = partdefinition.addOrReplaceChild("left_wing_arm", CubeListBuilder.create().texOffs(47, 33).addBox(0.0f, -2.0f, -0.1f, 2.0f, 2.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)8.0f, (float)2.0f, (float)0.0873f, (float)0.3927f, (float)0.0f));
        PartDefinition left_inner_wing = left_wing_arm.addOrReplaceChild("left_inner_wing", CubeListBuilder.create().texOffs(31, 33).addBox(-1.0f, -7.0f, 0.0f, 6.0f, 14.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition left_outer_wing = left_inner_wing.addOrReplaceChild("left_outer_wing", CubeListBuilder.create().texOffs(46, 43).addBox(0.0f, -3.0f, 0.0f, 8.0f, 20.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)5.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition right_wing_arm = partdefinition.addOrReplaceChild("right_wing_arm", CubeListBuilder.create().texOffs(47, 33).addBox(-2.0f, -2.0f, -0.1f, 2.0f, 2.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.0f, (float)8.0f, (float)2.0f, (float)0.0873f, (float)-0.3927f, (float)0.0f));
        PartDefinition right_inner_wing = right_wing_arm.addOrReplaceChild("right_inner_wing", CubeListBuilder.create().texOffs(31, 33).mirror().addBox(-5.0f, -7.0f, 0.0f, 6.0f, 14.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition right_outer_wing = right_inner_wing.addOrReplaceChild("right_outer_wing", CubeListBuilder.create().texOffs(46, 43).mirror().addBox(-8.0f, -2.0f, 0.0f, 8.0f, 20.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftWingArm, (Object)this.rightWingArm, (Object)this.leftLeg, (Object)this.rightLeg, (Object)this.hat);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch);
        this.head.setPos(0.0f, 4.0f, 0.0f);
        this.hat.copyFrom(this.head);
        this.rightArm.setPos(-5.0f, 5.0f, 0.0f);
        this.leftArm.setPos(5.0f, 5.0f, 0.0f);
        this.rightLeg.setPos(-1.9f, 16.0f, 0.0f);
        this.leftLeg.setPos(1.9f, 16.0f, 0.0f);
        float flyingTime = ((Fury)((Object)entity)).getFlyingTime(ageInTicks - (float)((Fury)((Object)entity)).tickCount);
        boolean flying = flyingTime > 0.08f;
        float wingSpeed = 0.35f;
        float wingSpan = 0.11f;
        if (flying) {
            wingSpeed += 0.225f;
            wingSpan += 0.06f;
        }
        float wingAngle = wingSpan - Mth.cos((float)((ageInTicks + (float)entity.getId()) * wingSpeed)) * wingSpan;
        this.leftWingInner.yRot = -wingSpan + wingAngle;
        this.leftWingOuter.yRot = 0.1491f + wingAngle;
        this.rightWingInner.yRot = -this.leftWingInner.yRot;
        this.rightWingOuter.yRot = -this.leftWingOuter.yRot;
        if (flying) {
            this.leftLeg.xRot *= 0.25f;
            this.rightLeg.xRot *= 0.25f;
        }
        this.leftArm.xRot *= 0.65f;
        this.rightArm.xRot *= 0.65f;
    }

    public void setupSnakeAnim(float ageInTicks) {
        this.hair.copyFrom(this.head);
        GFModelUtil.setupSnakeAnim(this.lowerSnakes, ageInTicks, 1.7f);
        GFModelUtil.setupSnakeAnim(this.middleSnakes, ageInTicks, 1.03f);
        GFModelUtil.setupSnakeAnim(this.upperSnakes, ageInTicks, 0.82f);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
    }

    public ModelPart getHair() {
        return this.hair;
    }
}

