/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.PartDefinition;

public final class GFModelUtil {
    public static final String HOLDER = "holder_";

    public static PartDefinition addOrReplaceOrthusHead(PartDefinition root, String name, float offsetX) {
        return root.addOrReplaceChild(name, CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -4.0f, 6.0f, 6.0f, 4.0f, CubeDeformation.NONE).texOffs(16, 14).addBox(-3.0f, -5.0f, -3.0f, 2.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(16, 14).addBox(1.0f, -5.0f, -3.0f, 2.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(0, 10).addBox(-1.5f, -0.0156f, -7.0f, 3.0f, 3.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)offsetX, (float)12.5f, (float)-5.0f));
    }

    public static PartDefinition createSnakeLayers(PartDefinition root, float radius, float deltaAngle, CubeDeformation cubeDeformation, int textureX, int textureY) {
        double count = 1.0;
        double tau = Math.PI * 2;
        for (double angle = 0.0; angle < tau; angle += (double)deltaAngle) {
            float ptX = (float)(Math.cos(angle) * (double)radius);
            float ptZ = (float)(Math.sin(angle) * (double)radius);
            float angY = (float)(angle - (double)(deltaAngle * 2.0f) * count);
            PartDefinition holder = root.addOrReplaceChild(HOLDER + String.valueOf((int)count), CubeListBuilder.create(), PartPose.offset((float)ptX, (float)-0.5f, (float)ptZ));
            PartDefinition snake = GFModelUtil.createSnakeLayer(holder, cubeDeformation, 0.0f, 0.0f, 0.0f, 0.0f, angY, 0.0f, textureX, textureY);
            count += 1.0;
        }
        return root;
    }

    public static PartDefinition createSnakeLayer(PartDefinition root, CubeDeformation cubeDeformation, float offsetX, float offsetY, float offsetZ, float angleX, float angleY, float angleZ, int textureX, int textureY) {
        PartDefinition lowerSnake = root.addOrReplaceChild("lower_snake", CubeListBuilder.create().texOffs(textureX, textureY).addBox(-0.5f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)offsetX, (float)offsetY, (float)offsetZ, (float)(0.5236f + angleX), (float)angleY, (float)angleZ));
        PartDefinition middleSnake = lowerSnake.addOrReplaceChild("middle_snake", CubeListBuilder.create().texOffs(textureX, textureY + 4).addBox(-0.5f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition upperSnake = middleSnake.addOrReplaceChild("upper_snake", CubeListBuilder.create().texOffs(textureX, textureY + 8).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 2.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        return lowerSnake;
    }

    public static List<ModelPart> getSnakeModelParts(ModelPart root, int count) {
        ArrayList<ModelPart> list = new ArrayList<ModelPart>();
        for (int i = 1; i <= count; ++i) {
            list.add(root.getChild(HOLDER + i).getChild("lower_snake"));
        }
        return list;
    }

    public static void setupSnakeAnim(List<ModelPart> list, float ticks, float baseAngleX) {
        int i = 0;
        for (ModelPart m : list) {
            m.xRot = baseAngleX + (float)Math.cos((double)ticks * 0.15 + (double)((float)i * 2.89f)) * 0.08f;
            ++i;
        }
    }

    public static PartDefinition addOrReplaceBullHead(PartDefinition root, String name, int hornTextureX, int hornTextureY) {
        PartDefinition head = root.addOrReplaceChild(name, CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE).texOffs(24, 0).addBox(-3.0f, -3.0f, -5.0f, 6.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition lower_right_horn = head.addOrReplaceChild("lower_right_horn", CubeListBuilder.create().texOffs(hornTextureX, hornTextureY).addBox(-1.5f, -4.0f, -2.0f, 1.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-3.0f, (float)-7.0f, (float)-2.0f, (float)1.3963f, (float)1.0472f, (float)0.0f));
        PartDefinition middle_right_horn = lower_right_horn.addOrReplaceChild("middle_right_horn", CubeListBuilder.create().texOffs(hornTextureX, hornTextureY + 6).addBox(-0.51f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.0f, (float)-4.0f, (float)-2.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition top_right_horn = middle_right_horn.addOrReplaceChild("top_right_horn", CubeListBuilder.create().texOffs(hornTextureX, hornTextureY + 11).addBox(-0.5f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition lower_left_horn = head.addOrReplaceChild("lower_left_horn", CubeListBuilder.create().texOffs(hornTextureX, hornTextureY).addBox(0.5f, -4.0f, -2.0f, 1.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)3.0f, (float)-7.0f, (float)-2.0f, (float)1.3963f, (float)-1.0472f, (float)0.0f));
        PartDefinition middle_left_horn = lower_left_horn.addOrReplaceChild("middle_left_horn", CubeListBuilder.create().texOffs(hornTextureX, hornTextureY + 6).addBox(7.49f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-7.0f, (float)-4.0f, (float)-2.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition top_left_horn = middle_left_horn.addOrReplaceChild("top_left_horn", CubeListBuilder.create().texOffs(hornTextureX, hornTextureY + 11).addBox(7.5f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        return head;
    }

    public static PartDefinition createCharybdisTeeth(PartDefinition root, String name, float yRot) {
        PartDefinition teeth = root.addOrReplaceChild(name, CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-30.0f, (float)0.0f, (float)0.0f, (float)yRot, (float)0.0f));
        teeth.addOrReplaceChild("tooth1", CubeListBuilder.create().texOffs(61, 31).addBox(0.0f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-10.0f, (float)0.0f, (float)8.5f, (float)-0.5672f, (float)-0.1309f, (float)-2.0944f));
        teeth.addOrReplaceChild("tooth2", CubeListBuilder.create().texOffs(61, 31).addBox(0.0f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-10.0f, (float)0.0f, (float)6.0f, (float)-0.4363f, (float)-0.0873f, (float)-2.0944f));
        teeth.addOrReplaceChild("tooth3", CubeListBuilder.create().texOffs(61, 31).addBox(0.0f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-10.0f, (float)0.0f, (float)3.5f, (float)-0.2618f, (float)0.2182f, (float)-2.0944f));
        teeth.addOrReplaceChild("tooth4", CubeListBuilder.create().texOffs(61, 31).addBox(0.0f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-10.0f, (float)0.0f, (float)0.5f, (float)-0.0436f, (float)-0.1309f, (float)-2.0944f));
        teeth.addOrReplaceChild("tooth5", CubeListBuilder.create().texOffs(61, 31).addBox(0.0f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-10.0f, (float)0.0f, (float)-2.5f, (float)0.2618f, (float)0.1745f, (float)-2.0944f));
        teeth.addOrReplaceChild("tooth6", CubeListBuilder.create().texOffs(61, 31).addBox(0.0f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-10.0f, (float)0.0f, (float)-5.0f, (float)0.4363f, (float)0.1309f, (float)-2.0944f));
        teeth.addOrReplaceChild("tooth7", CubeListBuilder.create().texOffs(61, 31).addBox(0.0f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-10.0f, (float)0.0f, (float)-7.5f, (float)0.5672f, (float)-0.0873f, (float)-2.0944f));
        teeth.addOrReplaceChild("tooth8", CubeListBuilder.create().texOffs(61, 31).addBox(0.0f, -0.5f, 0.0f, 1.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-9.0f, (float)-0.5f, (float)-10.0f, (float)0.7854f, (float)0.0873f, (float)-2.0944f));
        return teeth;
    }

    public static PartDefinition createCharybdisArms(PartDefinition root, String name, float yRot) {
        PartDefinition arms = root.addOrReplaceChild(name, CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)yRot, (float)0.0f));
        PartDefinition holder_0 = arms.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-12.0f, (float)-1.0f, (float)-8.0f, (float)0.3491f, (float)0.0f, (float)-1.2217f));
        PartDefinition lower_arm = holder_0.addOrReplaceChild("lower_arm", CubeListBuilder.create().texOffs(73, 0).addBox(-1.0f, -5.0f, -1.5f, 3.0f, 6.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition middle_arm = lower_arm.addOrReplaceChild("middle_arm", CubeListBuilder.create().texOffs(86, 0).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 6.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.5f, (float)-5.0f, (float)0.0f));
        PartDefinition upper_arm = middle_arm.addOrReplaceChild("upper_arm", CubeListBuilder.create().texOffs(95, 0).addBox(-0.5f, -5.0f, -0.5f, 1.0f, 6.0f, 1.0f, CubeDeformation.NONE).texOffs(73, 10).addBox(-1.0f, -8.0f, -2.5f, 1.0f, 8.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition holder_1 = arms.addOrReplaceChild("middle_arm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-12.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.2217f));
        PartDefinition lower_arm2 = holder_1.addOrReplaceChild("lower_arm", CubeListBuilder.create().texOffs(73, 0).addBox(-1.0f, -5.0f, -1.5f, 3.0f, 6.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition middle_arm2 = lower_arm2.addOrReplaceChild("middle_arm", CubeListBuilder.create().texOffs(86, 0).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 6.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.5f, (float)-5.0f, (float)0.0f));
        PartDefinition upper_arm2 = middle_arm2.addOrReplaceChild("upper_arm", CubeListBuilder.create().texOffs(95, 0).addBox(-0.5f, -5.0f, -0.5f, 1.0f, 6.0f, 1.0f, CubeDeformation.NONE).texOffs(73, 10).addBox(-1.0f, -8.0f, -2.5f, 1.0f, 8.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition holder_2 = arms.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-12.0f, (float)-1.0f, (float)8.0f, (float)-0.3491f, (float)0.0f, (float)-1.2217f));
        PartDefinition lower_arm3 = holder_2.addOrReplaceChild("lower_arm", CubeListBuilder.create().texOffs(73, 0).addBox(-1.0f, -5.0f, -1.5f, 3.0f, 6.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition middle_arm3 = lower_arm3.addOrReplaceChild("middle_arm", CubeListBuilder.create().texOffs(86, 0).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 6.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.5f, (float)-5.0f, (float)0.0f));
        PartDefinition upper_arm3 = middle_arm3.addOrReplaceChild("upper_arm", CubeListBuilder.create().texOffs(95, 0).addBox(-0.5f, -5.0f, -0.5f, 1.0f, 6.0f, 1.0f, CubeDeformation.NONE).texOffs(73, 10).addBox(-1.0f, -8.0f, -2.5f, 1.0f, 8.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        return arms;
    }

    public static List<Tuple3<ModelPart>> getCharybdisArmsList(ModelPart root) {
        return new ImmutableList.Builder().addAll(GFModelUtil.getCharybdisArms(root.getChild("east_arms"))).addAll(GFModelUtil.getCharybdisArms(root.getChild("south_arms"))).addAll(GFModelUtil.getCharybdisArms(root.getChild("west_arms"))).addAll(GFModelUtil.getCharybdisArms(root.getChild("north_arms"))).build();
    }

    public static List<Tuple3<ModelPart>> getCharybdisArms(ModelPart root) {
        return new ImmutableList.Builder().add(GFModelUtil.getCharybdisArmParts(root.getChild("left_arm"))).add(GFModelUtil.getCharybdisArmParts(root.getChild("middle_arm"))).add(GFModelUtil.getCharybdisArmParts(root.getChild("right_arm"))).build();
    }

    public static Tuple3<ModelPart> getCharybdisArmParts(ModelPart root) {
        ModelPart lowerArm = root.getChild("lower_arm");
        ModelPart middleArm = lowerArm.getChild("middle_arm");
        ModelPart upperArm = middleArm.getChild("upper_arm");
        return new Tuple3<ModelPart>(lowerArm, middleArm, upperArm);
    }

    public static PartDefinition createCharybdisUpperFringe(PartDefinition root, String name, float yRot) {
        PartDefinition holder = root.addOrReplaceChild(name, CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)yRot, (float)0.0f));
        holder.addOrReplaceChild("fringe", CubeListBuilder.create().texOffs(0, 84).addBox(-12.0f, 0.0f, -4.0f, 24.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-12.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        return holder;
    }

    public static List<ModelPart> getSingleCharybdisFringeList(ModelPart root) {
        return new ImmutableList.Builder().add((Object)GFModelUtil.getSingleCharybdisFringe(root.getChild("east_fringe"))).add((Object)GFModelUtil.getSingleCharybdisFringe(root.getChild("south_fringe"))).add((Object)GFModelUtil.getSingleCharybdisFringe(root.getChild("west_fringe"))).add((Object)GFModelUtil.getSingleCharybdisFringe(root.getChild("north_fringe"))).build();
    }

    public static ModelPart getSingleCharybdisFringe(ModelPart root) {
        return root.getChild("fringe");
    }

    public static List<ModelPart> getTripleCharybdisFringeList(ModelPart root) {
        return new ImmutableList.Builder().addAll(GFModelUtil.getTripleCharybdisFringe(root.getChild("east_fringe"))).addAll(GFModelUtil.getTripleCharybdisFringe(root.getChild("south_fringe"))).addAll(GFModelUtil.getTripleCharybdisFringe(root.getChild("west_fringe"))).addAll(GFModelUtil.getTripleCharybdisFringe(root.getChild("north_fringe"))).build();
    }

    public static List<ModelPart> getTripleCharybdisFringe(ModelPart root) {
        return ImmutableList.of((Object)root.getChild("left_fringe"), (Object)root.getChild("middle_fringe"), (Object)root.getChild("right_fringe"));
    }

    public static PartDefinition createCharybdisUpperMiddleFringe(PartDefinition root, String name, float yRot) {
        PartDefinition holder = root.addOrReplaceChild(name, CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)yRot, (float)0.0f));
        holder.addOrReplaceChild("left_fringe", CubeListBuilder.create().texOffs(0, 89).addBox(-1.0f, -6.0f, -3.0f, 1.0f, 10.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-5.0f, (float)0.0f, (float)-8.0f));
        holder.addOrReplaceChild("middle_fringe", CubeListBuilder.create().texOffs(0, 89).addBox(-1.0f, -6.0f, -4.0f, 1.0f, 10.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)-8.0f));
        holder.addOrReplaceChild("right_fringe", CubeListBuilder.create().texOffs(0, 89).addBox(-1.0f, -6.0f, -3.0f, 1.0f, 10.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)5.0f, (float)0.0f, (float)-8.0f));
        return holder;
    }

    public static PartDefinition createCharybdisLowerMiddleFringe(PartDefinition root, String name, float yRot) {
        PartDefinition holder = root.addOrReplaceChild(name, CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)yRot, (float)0.0f));
        holder.addOrReplaceChild("left_fringe", CubeListBuilder.create().texOffs(9, 89).addBox(-1.0f, -4.0f, -3.0f, 1.0f, 8.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)-0.0436f, (float)0.0f));
        holder.addOrReplaceChild("middle_fringe", CubeListBuilder.create().texOffs(9, 89).addBox(-1.0f, -4.0f, -4.0f, 1.0f, 8.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)-0.0436f, (float)0.0f));
        holder.addOrReplaceChild("right_fringe", CubeListBuilder.create().texOffs(9, 89).addBox(-1.0f, -4.0f, -3.0f, 1.0f, 8.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)-0.0436f, (float)0.0f));
        return holder;
    }

    public static PartDefinition createCharybdisLowerFringe(PartDefinition root, String name, float yRot) {
        PartDefinition holder = root.addOrReplaceChild(name, CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)yRot, (float)0.0f));
        holder.addOrReplaceChild("fringe", CubeListBuilder.create().texOffs(9, 89).addBox(-1.0f, -4.0f, -3.0f, 1.0f, 8.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-4.0f, (float)-3.0f));
        return holder;
    }

    public static void setupCharybdisArmAnim(ModelPart lowerArm, ModelPart middleArm, ModelPart upperArm, float idleSwingCos, float throwingTimeLeft, float throwingZ) {
        lowerArm.xRot = idleSwingCos * 0.14f * throwingTimeLeft;
        lowerArm.zRot = idleSwingCos * 0.09f * throwingTimeLeft + 1.15f * throwingZ;
        middleArm.zRot = idleSwingCos * 0.14f * throwingTimeLeft + 0.26f * throwingZ;
        upperArm.zRot = idleSwingCos * 0.14f * throwingTimeLeft + 0.36f * throwingZ;
    }

    public static PartDefinition addOrReplaceCerberusHead(PartDefinition root, String name, float x, float y, float z, float xRot) {
        PartDefinition head = root.addOrReplaceChild(name, CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f + xRot, -2.0f, -5.0f, 5.0f, 6.0f, 5.0f, CubeDeformation.NONE).texOffs(21, 0).addBox(-1.5f + xRot, 1.0f, -9.0f, 3.0f, 2.0f, 4.0f, CubeDeformation.NONE).texOffs(16, 0).addBox(-2.5f + xRot, -4.0f, -2.0f, 2.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(16, 0).mirror().addBox(0.5f + xRot, -4.0f, -2.0f, 2.0f, 2.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)x, (float)y, (float)z));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(21, 6).addBox(-1.5f + xRot, 0.0f, -4.0f, 3.0f, 1.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-5.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        return head;
    }

    public static PartDefinition addOrReplaceRamHorn(PartDefinition root, String name, float x, float y, float z, boolean isLeft) {
        PartDefinition horn;
        if (isLeft) {
            horn = root.addOrReplaceChild(name, CubeListBuilder.create(), PartPose.offsetAndRotation((float)x, (float)y, (float)z, (float)-0.2618f, (float)0.0f, (float)0.0f));
            PartDefinition lowerLeftHorn = horn.addOrReplaceChild("lower_left_horn", CubeListBuilder.create().texOffs(58, 0).addBox(0.0f, -4.0f, 0.0f, 1.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition lowerMiddleLeftHorn = lowerLeftHorn.addOrReplaceChild("lower_middle_left_horn", CubeListBuilder.create().texOffs(58, 6).addBox(0.0f, -4.0f, 0.0f, 1.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.7854f, (float)0.1745f, (float)0.0f));
            PartDefinition middleLeftHorn = lowerMiddleLeftHorn.addOrReplaceChild("middle_left_horn", CubeListBuilder.create().texOffs(58, 13).addBox(0.0f, -4.0f, 0.0f, 1.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-1.2217f, (float)0.1745f, (float)0.0f));
            PartDefinition upperMiddleLeftHorn = middleLeftHorn.addOrReplaceChild("upper_middle_left_horn", CubeListBuilder.create().texOffs(58, 18).addBox(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-1.2217f, (float)0.1745f, (float)0.0f));
            PartDefinition partDefinition = upperMiddleLeftHorn.addOrReplaceChild("upper_left_horn", CubeListBuilder.create().texOffs(58, 22).addBox(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)-1.0472f, (float)0.1745f, (float)0.0f));
        } else {
            horn = root.addOrReplaceChild(name, CubeListBuilder.create(), PartPose.offsetAndRotation((float)x, (float)y, (float)z, (float)-0.2618f, (float)0.0f, (float)0.0f));
            PartDefinition lowerRightHorn = horn.addOrReplaceChild("lower_right_horn", CubeListBuilder.create().texOffs(58, 0).addBox(-1.0f, -4.0f, 0.0f, 1.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition lowerMiddleRightHorn = lowerRightHorn.addOrReplaceChild("lower_middle_right_horn", CubeListBuilder.create().texOffs(58, 6).addBox(-1.0f, -4.0f, 0.0f, 1.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.7854f, (float)-0.1745f, (float)0.0f));
            PartDefinition middleRightHorn = lowerMiddleRightHorn.addOrReplaceChild("middle_right_horn", CubeListBuilder.create().texOffs(58, 13).addBox(-1.0f, -4.0f, 0.0f, 1.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-1.2217f, (float)-0.1745f, (float)0.0f));
            PartDefinition upperMiddleRightHorn = middleRightHorn.addOrReplaceChild("upper_middle_right_horn", CubeListBuilder.create().texOffs(58, 18).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-1.2217f, (float)-0.1745f, (float)0.0f));
            PartDefinition partDefinition = upperMiddleRightHorn.addOrReplaceChild("upper_right_horn", CubeListBuilder.create().texOffs(58, 22).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)-1.0472f, (float)-0.1745f, (float)0.0f));
        }
        return horn;
    }

    public static PartDefinition addOrReplaceScyllaLegs(PartDefinition root, int count) {
        float arc = (float)Math.PI * 2 / Math.max(1.0f, (float)count);
        for (int index = 0; index < count; ++index) {
            float angY = arc * (float)index;
            PartDefinition holder = root.addOrReplaceChild(HOLDER + String.valueOf(index), CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)angY, (float)0.0f));
            PartDefinition partDefinition = GFModelUtil.addOrReplaceScyllaLeg(holder);
        }
        return root;
    }

    public static PartDefinition addOrReplaceScyllaLeg(PartDefinition root) {
        PartDefinition lowerLeg = root.addOrReplaceChild("lower_leg", CubeListBuilder.create().texOffs(32, 22).addBox(-3.0f, -5.0f, -9.0f, 6.0f, 5.0f, 9.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition middleLeg = lowerLeg.addOrReplaceChild("middle_leg", CubeListBuilder.create().texOffs(62, 22).addBox(-2.0f, -1.0f, -8.0f, 4.0f, 4.0f, 10.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-8.0f, (float)-2.0071f, (float)0.0f, (float)0.0f));
        PartDefinition upperLeg = middleLeg.addOrReplaceChild("upper_leg", CubeListBuilder.create().texOffs(24, 38).addBox(-1.5f, -0.25f, -9.0f, 3.0f, 4.0f, 9.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-0.75f, (float)-7.75f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition monsterHead = upperLeg.addOrReplaceChild("monster_head", CubeListBuilder.create().texOffs(32, 54).addBox(-2.0f, -1.5f, -3.0f, 4.0f, 8.0f, 5.0f, CubeDeformation.NONE).texOffs(0, 70).addBox(-2.0f, 0.5f, -6.0f, 4.0f, 2.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)1.25f, (float)-9.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        return root;
    }

    public static List<Tuple4<ModelPart>> getScyllaLegs(ModelPart root, int count) {
        ArrayList<Tuple4<ModelPart>> list = new ArrayList<Tuple4<ModelPart>>();
        for (int i = 0; i < count; ++i) {
            list.add(GFModelUtil.getScyllaLeg(root.getChild(HOLDER + i)));
        }
        return list;
    }

    public static Tuple4<ModelPart> getScyllaLeg(ModelPart holder) {
        ModelPart lowerLeg = holder.getChild("lower_leg");
        ModelPart middleLeg = lowerLeg.getChild("middle_leg");
        ModelPart upperLeg = middleLeg.getChild("upper_leg");
        ModelPart head = upperLeg.getChild("monster_head");
        return new Tuple4<ModelPart>(lowerLeg, middleLeg, upperLeg, head);
    }

    public static void setupScyllaLegAnim(Tuple4<ModelPart> leg, float idleSwingCos) {
        ((ModelPart)leg.left).xRot = -idleSwingCos * 0.18f;
        ((ModelPart)leg.leftMiddle).xRot = -2.0071f + idleSwingCos * 0.4f;
        ((ModelPart)leg.rightMiddle).xRot = 0.8727f + idleSwingCos * 0.22f;
        ((ModelPart)leg.right).xRot = -0.3491f - idleSwingCos * 0.6f;
    }

    @Immutable
    public static class Tuple3<T> {
        public final T left;
        public final T middle;
        public final T right;

        public Tuple3(T left, T middle, T right) {
            this.left = left;
            this.middle = middle;
            this.right = right;
        }
    }

    @Immutable
    public static class Tuple4<T> {
        public final T left;
        public final T leftMiddle;
        public final T rightMiddle;
        public final T right;

        public Tuple4(T left, T leftMiddle, T rightMiddle, T right) {
            this.left = left;
            this.leftMiddle = leftMiddle;
            this.rightMiddle = rightMiddle;
            this.right = right;
        }
    }

    @Immutable
    public static class Tuple5<T> {
        public final T left;
        public final T leftMiddle;
        public final T middle;
        public final T rightMiddle;
        public final T right;

        public Tuple5(T left, T leftMiddle, T middle, T rightMiddle, T right) {
            this.left = left;
            this.leftMiddle = leftMiddle;
            this.middle = middle;
            this.rightMiddle = rightMiddle;
            this.right = right;
        }
    }
}

