/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import greekfantasy.client.entity.model.GiganteModel;
import greekfantasy.entity.boss.Geryon;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;

public class GeryonModel<T extends Geryon>
extends GiganteModel<T> {
    public static final ModelLayerLocation GERYON_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"geryon"), "geryon");
    public static final ModelLayerLocation GERYON_ARMOR_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"geryon_armor"), "geryon_armor");
    protected final ModelPart leftHead;
    protected final ModelPart rightHead;

    public GeryonModel(ModelPart root) {
        super(root);
        this.leftHead = root.getChild("left_head");
        this.rightHead = root.getChild("right_head");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = GiganteModel.createMesh(cubeDeformation);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("left_head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.0f, -5.0f, 10.0f, 10.0f, 10.0f, cubeDeformation.extend(-1.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.0f, -5.0f, 10.0f, 10.0f, 10.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)0.25f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.0f, -5.0f, 10.0f, 10.0f, 10.0f, cubeDeformation.extend(-1.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    protected Iterable<ModelPart> headParts() {
        return Iterables.concat((Iterable)super.headParts(), (Iterable)ImmutableList.of((Object)this.leftHead, (Object)this.rightHead));
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch);
        this.leftHead.copyFrom(this.head);
        this.leftHead.x += -8.0f;
        this.leftHead.y += 1.0f;
        this.rightHead.copyFrom(this.head);
        this.rightHead.x += 8.0f;
        this.rightHead.y += 1.0f;
        float partialTick = ageInTicks - (float)((Geryon)entity).tickCount;
        float smashTime = ((Geryon)entity).getSmashPercent(partialTick);
        float summonTime = ((Geryon)entity).getSummonPercent(partialTick);
        if (summonTime > 0.0f) {
            ModelPart arm = this.getArm(entity.getMainArm().getOpposite());
            arm.xRot = -1.5708f * summonTime;
            arm.yRot = 0.680678f * summonTime * (float)(entity.getMainArm() == HumanoidArm.RIGHT ? -1 : 1);
        }
        if (smashTime > 0.0f) {
            float downTrigger = 0.9f;
            float downMult = 12.5f;
            float smashAngleX = 2.02f;
            float smashAngleY = 0.52f;
            this.rightArm.xRot = -12.5f * Math.min(0.100000024f * smashTime, -0.5f * (smashTime - 0.95f)) * 2.02f;
            this.rightArm.yRot = -Math.min(smashTime * 1.35f, 1.0f) * 0.52f;
            this.leftArm.xRot = this.rightArm.xRot;
            this.leftArm.yRot = -this.rightArm.yRot;
        }
    }
}

