/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class GiganteModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public static final ModelLayerLocation GIGANTE_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"gigante"), "gigante");

    public GiganteModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = GiganteModel.createMesh(CubeDeformation.NONE);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)cubeDeformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.0f, -5.0f, 10.0f, 10.0f, 10.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(40, 0).addBox(-5.0f, -2.0f, -5.0f, 10.0f, 10.0f, 10.0f, cubeDeformation.extend(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 20).addBox(-6.0f, -32.0f, -3.0f, 12.0f, 16.0f, 6.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(64, 20).addBox(0.0f, -2.0f, -3.0f, 6.0f, 16.0f, 6.0f, cubeDeformation), PartPose.offset((float)6.0f, (float)-6.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 20).addBox(-6.0f, -2.0f, -3.0f, 6.0f, 16.0f, 6.0f, cubeDeformation), PartPose.offset((float)-6.0f, (float)-6.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(64, 42).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f, cubeDeformation), PartPose.offset((float)3.0f, (float)8.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(40, 42).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 6.0f, cubeDeformation), PartPose.offset((float)-3.0f, (float)8.0f, (float)0.0f));
        return meshdefinition;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float partialTick, float rotationYaw, float rotationPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, partialTick, rotationYaw, rotationPitch);
        this.head.setPos(0.0f, -16.0f, 0.0f);
        this.hat.setPos(0.0f, -16.0f, 0.0f);
        this.body.setPos(0.0f, 24.0f, 0.0f);
        this.leftArm.setPos(6.0f, -6.0f, 0.0f);
        this.rightArm.setPos(-6.0f, -6.0f, 0.0f);
        this.leftLeg.setPos(3.0f, 8.0f, 0.0f);
        this.rightLeg.setPos(-3.0f, 8.0f, 0.0f);
        this.head.xRot = Mth.clamp((float)this.head.xRot, (float)-0.261799f, (float)0.261799f);
        this.head.yRot = Mth.clamp((float)this.head.xRot, (float)-0.785398f, (float)0.785398f);
        this.hat.copyFrom(this.head);
    }

    public void translateToHand(HumanoidArm sideIn, PoseStack poseStack) {
        float dX = sideIn == HumanoidArm.RIGHT ? -2.0f : 2.0f;
        float dZ = -3.5f;
        float dY = 3.0f;
        ModelPart armModel = this.getArm(sideIn);
        armModel.x += dX;
        armModel.y += dY;
        armModel.z += dZ;
        armModel.translateAndRotate(poseStack);
        armModel.x -= dX;
        armModel.y -= dY;
        armModel.z -= dZ;
    }
}

