/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import greekfantasy.client.entity.model.DrakainaModel;
import greekfantasy.client.entity.model.GFModelUtil;
import greekfantasy.entity.monster.Gorgon;
import java.util.List;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class GorgonModel<T extends Gorgon>
extends DrakainaModel<T> {
    public static final ModelLayerLocation GORGON_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"gorgon"), "gorgon");
    protected static final int LOWER_HAIR_COUNT = 12;
    protected static final int MIDDLE_HAIR_COUNT = 8;
    protected static final int UPPER_HAIR_COUNT = 6;
    protected final ModelPart hair;
    protected final ModelPart lowerHair;
    protected final ModelPart middleHair;
    protected final ModelPart upperHair;
    protected final List<ModelPart> lowerSnakes;
    protected final List<ModelPart> middleSnakes;
    protected final List<ModelPart> upperSnakes;

    public GorgonModel(ModelPart root) {
        super(root);
        this.hair = this.head.getChild("hair");
        this.lowerHair = this.hair.getChild("lower_hair");
        this.middleHair = this.hair.getChild("middle_hair");
        this.upperHair = this.hair.getChild("upper_hair");
        this.lowerSnakes = GFModelUtil.getSnakeModelParts(this.lowerHair, 12);
        this.middleSnakes = GFModelUtil.getSnakeModelParts(this.middleHair, 8);
        this.upperSnakes = GFModelUtil.getSnakeModelParts(this.upperHair, 6);
        this.hat.visible = false;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = DrakainaModel.createMesh(CubeDeformation.NONE, 0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition chest = partdefinition.getChild("body").addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 17).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-4.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition hair = head.addOrReplaceChild("hair", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition lowerHair = hair.addOrReplaceChild("lower_hair", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition middleHair = hair.addOrReplaceChild("middle_hair", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition upperHair = hair.addOrReplaceChild("upper_hair", CubeListBuilder.create(), PartPose.ZERO);
        GFModelUtil.createSnakeLayers(lowerHair, 3.8f, 0.5235988f, CubeDeformation.NONE, 46, 52);
        GFModelUtil.createSnakeLayers(middleHair, 2.25f, 0.7853982f, CubeDeformation.NONE, 46, 52);
        GFModelUtil.createSnakeLayers(upperHair, 1.25f, 1.0471976f, CubeDeformation.NONE, 46, 52);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.setupSnakeAnim(ageInTicks);
    }

    public void setupSnakeAnim(float ageInTicks) {
        GFModelUtil.setupSnakeAnim(this.lowerSnakes, ageInTicks, 1.7f);
        GFModelUtil.setupSnakeAnim(this.middleSnakes, ageInTicks, 1.03f);
        GFModelUtil.setupSnakeAnim(this.upperSnakes, ageInTicks, 0.82f);
    }
}

