/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.entity.util.HasHorseVariant;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class HalfHorseModel<T extends LivingEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation HALF_HORSE_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"half_horse"), "half_horse");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart tail;

    public HalfHorseModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HalfHorseModel.createMesh(CubeDeformation.NONE, 0.0f);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, float offset) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-5.0f, -8.0f, -17.0f, 10.0f, 10.0f, 22.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)(11.0f + offset), (float)6.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.offset((float)-3.0f, (float)(13.0f + offset), (float)-9.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.offset((float)3.0f, (float)(13.0f + offset), (float)-9.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.offset((float)-3.0f, (float)(13.0f + offset), (float)9.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.offset((float)3.0f, (float)(13.0f + offset), (float)9.0f));
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(42, 36).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 14.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)(4.0f + offset), (float)11.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        return meshdefinition;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch) {
        this.body.y = 11.0f;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float ticks = (float)((LivingEntity)entity).tickCount + partialTick;
        float swimmingOffset = entity.isInWater() ? 0.2f : 1.0f;
        float limbSwingCos = Mth.cos((float)(swimmingOffset * limbSwing * 0.6662f + (float)Math.PI));
        float limbSwingAmountCos = limbSwingCos * 0.8f * limbSwingAmount;
        float rearingTime = ((HasHorseVariant)entity).getRearingAmount(partialTick);
        float rearingTimeLeft = 1.0f - rearingTime;
        this.body.xRot = 0.0f;
        this.body.xRot = rearingTime * -0.7853982f + rearingTimeLeft * this.body.xRot;
        float rearingAmount = 0.2617994f * rearingTime;
        float rearingCos = Mth.cos((float)(ticks * 0.6f + (float)Math.PI));
        this.leftFrontLeg.y = 2.0f * rearingTime + 13.0f * rearingTimeLeft;
        this.leftFrontLeg.z = -6.0f * rearingTime - 9.0f * rearingTimeLeft;
        this.rightFrontLeg.y = this.leftFrontLeg.y;
        this.rightFrontLeg.z = this.leftFrontLeg.z;
        float frontAngleCos = (-1.0471976f + rearingCos) * rearingTime + limbSwingAmountCos * rearingTimeLeft;
        float frontAngleSin = (-1.0471976f - rearingCos) * rearingTime - limbSwingAmountCos * rearingTimeLeft;
        this.leftHindLeg.xRot = rearingAmount - limbSwingCos * 0.5f * limbSwingAmount * rearingTimeLeft;
        this.rightHindLeg.xRot = rearingAmount + limbSwingCos * 0.5f * limbSwingAmount * rearingTimeLeft;
        this.leftFrontLeg.xRot = frontAngleCos;
        this.rightFrontLeg.xRot = frontAngleSin;
        boolean tailSwinging = ((HasHorseVariant)entity).getTailCounter() != 0;
        this.tail.xRot = 0.5235988f + limbSwingAmount * 0.75f;
        this.tail.y = 10.0f * rearingTime + 4.0f * rearingTimeLeft;
        this.tail.z = 13.5f * rearingTime + 9.5f * rearingTimeLeft;
        this.tail.yRot = tailSwinging ? Mth.cos((float)(ticks * 0.7f)) : 0.0f;
        boolean child = entity.isBaby();
        this.body.y = child ? 10.8f : 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

