/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import greekfantasy.entity.monster.Harpy;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class HarpyModel<T extends Harpy>
extends HumanoidModel<T> {
    public static final ModelLayerLocation HARPY_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"harpy"), "harpy");
    private final ModelPart leftWing1;
    private final ModelPart leftWing2;
    private final ModelPart leftWing3;
    private final ModelPart rightWing1;
    private final ModelPart rightWing2;
    private final ModelPart rightWing3;

    public HarpyModel(ModelPart root) {
        super(root);
        this.leftWing1 = root.getChild("left_inner_wing");
        this.leftWing2 = this.leftWing1.getChild("left_middle_wing");
        this.leftWing3 = this.leftWing2.getChild("left_outer_wing");
        this.rightWing1 = root.getChild("right_inner_wing");
        this.rightWing2 = this.rightWing1.getChild("right_middle_wing");
        this.rightWing3 = this.rightWing2.getChild("right_outer_wing");
        this.rightArm.visible = false;
        this.leftArm.visible = false;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE).texOffs(40, 16).addBox(-4.0f, 0.0f, 3.0f, 8.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.ZERO);
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.ZERO);
        body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(16, 33).addBox(-4.01f, 0.0f, 0.0f, 8.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(46, 56).addBox(-4.0f, 0.0f, -1.0f, 8.0f, 7.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 17).addBox(-2.1f, 0.0f, -2.0f, 3.0f, 11.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition right_foot = right_leg.addOrReplaceChild("right_foot", CubeListBuilder.create(), PartPose.offset((float)-0.1f, (float)0.0f, (float)0.0f));
        right_foot.addOrReplaceChild("right_front_outer_toe", CubeListBuilder.create().texOffs(16, 42).addBox(-1.0f, 0.0f, -4.0f, 1.0f, 1.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.0f, (float)10.0f, (float)-2.0f, (float)0.3491f, (float)0.3491f, (float)0.0f));
        right_foot.addOrReplaceChild("right_front_inner_toe", CubeListBuilder.create().texOffs(16, 42).addBox(0.0f, 0.0f, -4.0f, 1.0f, 1.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-2.0f, (float)0.3491f, (float)-0.3491f, (float)0.0f));
        right_foot.addOrReplaceChild("right_back_toe", CubeListBuilder.create().texOffs(27, 43).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 33).addBox(-0.9f, 0.0f, -2.0f, 3.0f, 11.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_foot = left_leg.addOrReplaceChild("left_foot", CubeListBuilder.create(), PartPose.offset((float)0.1f, (float)0.0f, (float)0.0f));
        left_foot.addOrReplaceChild("left_front_inner_toe", CubeListBuilder.create().texOffs(16, 42).addBox(-1.0f, 0.0f, -4.0f, 1.0f, 1.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-2.0f, (float)0.3491f, (float)0.3491f, (float)0.0f));
        left_foot.addOrReplaceChild("left_front_outer_toe", CubeListBuilder.create().texOffs(16, 42).addBox(0.0f, 0.0f, -4.0f, 1.0f, 1.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)10.0f, (float)-2.0f, (float)0.3491f, (float)-0.3491f, (float)0.0f));
        left_foot.addOrReplaceChild("left_back_toe", CubeListBuilder.create().texOffs(27, 43).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)10.0f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition left_inner_wing = partdefinition.addOrReplaceChild("left_inner_wing", CubeListBuilder.create().texOffs(0, 48).mirror().addBox(0.0f, 0.0f, -1.0f, 6.0f, 10.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)1.0472f));
        PartDefinition left_middle_wing = left_inner_wing.addOrReplaceChild("left_middle_wing", CubeListBuilder.create().texOffs(14, 48).mirror().addBox(0.0f, -1.0f, -1.0f, 8.0f, 10.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition left_outer_wing = left_middle_wing.addOrReplaceChild("left_outer_wing", CubeListBuilder.create().texOffs(32, 48).mirror().addBox(0.0f, -1.0f, -1.0f, 6.0f, 10.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition right_inner_wing = partdefinition.addOrReplaceChild("right_inner_wing", CubeListBuilder.create().texOffs(0, 48).addBox(-6.0f, 0.0f, -1.0f, 6.0f, 10.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition right_middle_wing = right_inner_wing.addOrReplaceChild("right_middle_wing", CubeListBuilder.create().texOffs(14, 48).addBox(-8.0f, -1.0f, -1.0f, 8.0f, 10.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)-6.0f, (float)1.0f, (float)0.0f));
        PartDefinition right_outer_wing = right_middle_wing.addOrReplaceChild("right_outer_wing", CubeListBuilder.create().texOffs(32, 48).addBox(-6.0f, -1.0f, -1.0f, 6.0f, 10.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)-8.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightWing1, (Object)this.leftWing1, (Object)this.hat);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float flyingTime = ((Harpy)((Object)entity)).getFlyingTime(ageInTicks - (float)((Harpy)((Object)entity)).tickCount);
        float flyingTimeLeft = 1.0f - flyingTime;
        float flyingTimeLeftAdjusted = Mth.clamp((float)(flyingTimeLeft + 0.15f), (float)0.0f, (float)1.0f);
        this.leftLeg.xRot *= flyingTimeLeftAdjusted * 0.6f;
        this.leftLeg.xRot += -0.35f * flyingTime;
        this.rightLeg.xRot *= flyingTimeLeftAdjusted * 0.6f;
        this.rightLeg.xRot += -0.35f * flyingTime;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float ticks = (float)(entity.getId() * 2 + ((Harpy)((Object)entity)).tickCount) + partialTick;
        float flyingTime = ((Harpy)((Object)entity)).getFlyingTime(partialTick);
        float flyingTimeLeft = 1.0f - flyingTime;
        float downSwing = 0.5f;
        float wingAngle = 0.5f;
        float wingSpeed = 0.7f;
        float cosTicks = flyingTime > 0.0f ? Mth.cos((float)(ticks * 0.7f)) : 0.0f;
        float sinTicks = flyingTime > 0.0f ? Mth.cos((float)(ticks * 0.7f + (float)Math.PI)) : 0.0f;
        float idleSwing = 0.035f * Mth.cos((float)(ticks * 0.08f));
        this.leftWing1.xRot = 1.0472f - 0.7854f * flyingTime;
        this.leftWing1.yRot = 0.0f + (cosTicks + 0.5f) * 0.5f * 0.75f * flyingTime;
        this.leftWing1.zRot = 0.9908f - 0.8908f * flyingTime + idleSwing;
        this.leftWing2.yRot = 0.5236f * flyingTimeLeft + (cosTicks + 0.5f) * 0.5f * flyingTime;
        this.leftWing3.yRot = 0.1745f * flyingTimeLeft + (cosTicks + 0.5f) * 0.5f * flyingTime;
        this.rightWing1.xRot = this.leftWing1.xRot;
        this.rightWing1.yRot = 0.0f + (sinTicks - 0.5f) * 0.32f * flyingTime;
        this.rightWing1.zRot = -0.9908f + 0.8908f * flyingTime - idleSwing;
        this.rightWing2.yRot = -0.5236f * flyingTimeLeft + (sinTicks - 0.5f) * 0.5f * flyingTime;
        this.rightWing3.yRot = -0.1745f * flyingTimeLeft + (sinTicks - 0.5f) * 0.5f * flyingTime;
    }
}

