/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class HoofedHumanoidModel<T extends LivingEntity>
extends HumanoidModel<T> {
    protected final ModelPart leftLegUpper;
    protected final ModelPart leftLegLower;
    protected final ModelPart leftHoof;
    protected final ModelPart rightLegUpper;
    protected final ModelPart rightLegLower;
    protected final ModelPart rightHoof;
    protected final ModelPart tailUpper;
    protected final ModelPart tailLower;

    public HoofedHumanoidModel(ModelPart root, boolean showTail, boolean showHat) {
        super(root);
        this.tailLower = this.body.getChild("tail_lower");
        this.tailUpper = this.tailLower.getChild("tail_upper");
        this.leftLegUpper = this.leftLeg.getChild("left_leg_upper");
        this.leftLegLower = this.leftLegUpper.getChild("left_leg_lower");
        this.leftHoof = this.leftLegLower.getChild("left_hoof");
        this.rightLegUpper = this.rightLeg.getChild("right_leg_upper");
        this.rightLegLower = this.rightLegUpper.getChild("right_leg_lower");
        this.rightHoof = this.rightLegLower.getChild("right_hoof");
        this.tailUpper.visible = this.tailLower.visible = showTail;
        this.hat.visible = showHat;
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)cubeDeformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail_lower = body.addOrReplaceChild("tail_lower", CubeListBuilder.create().texOffs(0, 51).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 5.0f, 1.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)2.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tail_upper = tail_lower.addOrReplaceChild("tail_upper", CubeListBuilder.create().texOffs(4, 51).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 1.0f, cubeDeformation).texOffs(0, 58).addBox(-1.0f, 2.5f, -0.5f, 2.0f, 4.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-1.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)12.0f, (float)2.0f));
        PartDefinition left_leg_upper = left_leg.addOrReplaceChild("left_leg_upper", CubeListBuilder.create().texOffs(16, 36).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_lower = left_leg_upper.addOrReplaceChild("left_leg_lower", CubeListBuilder.create().texOffs(16, 46).addBox(-1.91f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-2.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_hoof = left_leg_lower.addOrReplaceChild("left_hoof", CubeListBuilder.create().texOffs(16, 56).addBox(-1.9f, 0.0f, -4.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)4.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)12.0f, (float)2.0f));
        PartDefinition right_leg_upper = right_leg.addOrReplaceChild("right_leg_upper", CubeListBuilder.create().texOffs(0, 16).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg_lower = right_leg_upper.addOrReplaceChild("right_leg_lower", CubeListBuilder.create().texOffs(0, 26).addBox(-2.09f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-2.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_hoof = right_leg_lower.addOrReplaceChild("right_hoof", CubeListBuilder.create().texOffs(0, 36).addBox(-2.1f, 0.0f, -4.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)4.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        return meshdefinition;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float limbSwingSin = Mth.cos((float)(limbSwing + (float)Math.PI)) * limbSwingAmount;
        float limbSwingCos = Mth.cos((float)limbSwing) * limbSwingAmount;
        float rightLegSwing = 0.38f * limbSwingSin;
        float leftLegSwing = 0.38f * limbSwingCos;
        this.rightLegLower.xRot = 0.7854f + rightLegSwing;
        this.rightHoof.xRot = -0.5236f - rightLegSwing;
        this.leftLegLower.xRot = 0.7854f + leftLegSwing;
        this.leftHoof.xRot = -0.5236f - leftLegSwing;
        if (this.tailUpper.visible) {
            float idleSwing = 0.1f * Mth.cos((float)(ageInTicks * 0.08f));
            float tailSwing = 0.42f * limbSwingCos;
            this.tailUpper.xRot = 0.6854f + tailSwing;
            this.tailLower.xRot = 0.3491f + tailSwing * 0.6f;
            this.tailUpper.zRot = idleSwing;
            this.tailLower.zRot = idleSwing * 0.85f;
        }
    }
}

