/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.entity.boss.Hydra;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class HydraBodyModel<T extends Hydra>
extends EntityModel<T> {
    public static final ModelLayerLocation HYDRA_BODY_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"hydra_body"), "hydra_body");
    private final ModelPart body;
    private final ModelPart upperBody;
    private final ModelPart middleBody;
    private final ModelPart bodyLower1;
    private final ModelPart bodyLower2;
    private final ModelPart bodyLower3;
    private final ModelPart bodyLower4;
    private final ModelPart bodyLower5;

    public HydraBodyModel(ModelPart root) {
        this.body = root.getChild("body");
        this.upperBody = this.body.getChild("upper_body");
        this.middleBody = this.upperBody.getChild("middle_body");
        this.bodyLower1 = this.middleBody.getChild("lower_body1");
        this.bodyLower2 = this.bodyLower1.getChild("lower_body2");
        this.bodyLower3 = this.bodyLower2.getChild("lower_body3");
        this.bodyLower4 = this.bodyLower3.getChild("lower_body4");
        this.bodyLower5 = this.bodyLower4.getChild("lower_body5");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)-9.0f));
        PartDefinition upperBody = body.addOrReplaceChild("upper_body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        upperBody.addOrReplaceChild("front_right_body", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-14.0f, -7.0f, 0.0f, 14.0f, 12.0f, 6.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-6.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        upperBody.addOrReplaceChild("front_left_body", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -7.0f, 0.0f, 14.0f, 12.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-6.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        upperBody.addOrReplaceChild("back_left_body", CubeListBuilder.create().texOffs(42, 0).addBox(0.0f, -7.01f, -6.0f, 12.0f, 12.0f, 6.0f, CubeDeformation.NONE).texOffs(120, 0).addBox(2.0f, -7.0f, 0.0f, 1.0f, 12.0f, 3.0f, CubeDeformation.NONE).texOffs(120, 0).addBox(6.0f, -7.0f, 0.0f, 1.0f, 12.0f, 3.0f, CubeDeformation.NONE).texOffs(120, 0).addBox(10.0f, -7.0f, 0.0f, 1.0f, 12.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)6.5f, (float)0.0f, (float)0.2618f, (float)0.0f));
        upperBody.addOrReplaceChild("back_right_body", CubeListBuilder.create().texOffs(42, 0).mirror().addBox(-12.0f, -7.01f, -6.0f, 12.0f, 12.0f, 6.0f, CubeDeformation.NONE).mirror(false).texOffs(120, 0).mirror().addBox(-3.0f, -7.0f, 0.0f, 1.0f, 12.0f, 3.0f, CubeDeformation.NONE).mirror(false).texOffs(120, 0).mirror().addBox(-7.0f, -7.0f, 0.0f, 1.0f, 12.0f, 3.0f, CubeDeformation.NONE).mirror(false).texOffs(120, 0).mirror().addBox(-11.0f, -7.0f, 0.0f, 1.0f, 12.0f, 3.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)6.5f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition middleBody = upperBody.addOrReplaceChild("middle_body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        middleBody.addOrReplaceChild("front_right_middle_body", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(-10.0f, -8.0f, 0.0f, 10.0f, 12.0f, 6.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-1.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        middleBody.addOrReplaceChild("front_left_middle_body", CubeListBuilder.create().texOffs(0, 20).addBox(0.0f, -8.0f, 0.0f, 10.0f, 12.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-1.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        middleBody.addOrReplaceChild("back_left_middle_body", CubeListBuilder.create().texOffs(34, 20).addBox(0.0f, -8.01f, -4.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.NONE).texOffs(120, 0).addBox(1.0f, -4.0f, 0.0f, 1.0f, 8.0f, 3.0f, CubeDeformation.NONE).texOffs(120, 0).addBox(5.0f, -4.0f, 0.0f, 1.0f, 8.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)9.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        middleBody.addOrReplaceChild("back_right_middle_body", CubeListBuilder.create().texOffs(34, 20).mirror().addBox(-8.0f, -8.01f, -4.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.NONE).mirror(false).texOffs(120, 0).mirror().addBox(-2.0f, -4.0f, 0.0f, 1.0f, 8.0f, 3.0f, CubeDeformation.NONE).mirror(false).texOffs(120, 0).mirror().addBox(-6.0f, -4.0f, 0.0f, 1.0f, 8.0f, 3.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)9.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition lower_body1 = middleBody.addOrReplaceChild("lower_body1", CubeListBuilder.create().texOffs(0, 40).addBox(-6.0f, 0.0f, 1.0f, 12.0f, 10.0f, 6.0f, CubeDeformation.NONE).texOffs(120, 0).addBox(0.0f, 3.0f, 7.0f, 1.0f, 7.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)11.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition lower_body2 = lower_body1.addOrReplaceChild("lower_body2", CubeListBuilder.create().texOffs(84, 0).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 10.0f, 5.0f, CubeDeformation.NONE).texOffs(120, 0).addBox(0.0f, 3.0f, 5.0f, 1.0f, 7.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)1.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition lower_body3 = lower_body2.addOrReplaceChild("lower_body3", CubeListBuilder.create().texOffs(84, 16).addBox(-4.0f, 0.0f, 0.01f, 8.0f, 10.0f, 5.0f, CubeDeformation.NONE).texOffs(120, 0).addBox(0.0f, 0.0f, 5.0f, 1.0f, 10.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition lower_body4 = lower_body3.addOrReplaceChild("lower_body4", CubeListBuilder.create().texOffs(84, 32).addBox(-3.0f, 0.0f, 0.01f, 6.0f, 10.0f, 5.0f, CubeDeformation.NONE).texOffs(120, 0).addBox(0.0f, 0.0f, 5.0f, 1.0f, 10.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)9.01f, (float)0.0f));
        PartDefinition lower_body5 = lower_body4.addOrReplaceChild("lower_body5", CubeListBuilder.create().texOffs(84, 48).addBox(-2.0f, 0.0f, 0.01f, 4.0f, 10.0f, 4.0f, CubeDeformation.NONE).texOffs(120, 16).addBox(0.0f, 0.0f, 4.0f, 1.0f, 10.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        float idleSwingCos = Mth.cos((float)(((float)((Hydra)((Object)entityIn)).tickCount + partialTick) * 0.12f));
        float limbSwingCos = Mth.cos((float)limbSwing);
        this.upperBody.yRot = limbSwingCos * 0.04f + idleSwingCos * 0.011f;
        this.middleBody.yRot = limbSwingCos * -0.12f + idleSwingCos * 0.011f;
        this.bodyLower1.yRot = idleSwingCos * -0.022f;
        this.bodyLower1.zRot = limbSwingCos * 0.1f;
        this.bodyLower2.zRot = limbSwingCos * -0.37f;
        this.bodyLower3.zRot = limbSwingCos * 0.77f;
        this.bodyLower4.zRot = limbSwingCos * -0.95f;
        this.bodyLower5.zRot = limbSwingCos * 0.72f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, int color) {
        this.body.render(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
    }
}

