/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.entity.boss.HydraHead;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class HydraHeadModel<T extends HydraHead>
extends EntityModel<T> {
    public static final ModelLayerLocation HYDRA_HEAD_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"hydra_head"), "hydra_head");
    protected final ModelPart severedNeck;
    protected final ModelPart neck;
    protected final ModelPart neck1;
    protected final ModelPart neck2;
    protected final ModelPart neck3;
    protected final ModelPart head;
    protected final ModelPart mouth;
    protected float spawnPercent;
    protected boolean severed;
    protected boolean charred;

    public HydraHeadModel(ModelPart root) {
        this.severedNeck = root.getChild("severed_neck");
        this.neck = root.getChild("neck");
        this.neck1 = this.neck.getChild("neck1");
        this.neck2 = this.neck1.getChild("neck2");
        this.neck3 = this.neck2.getChild("neck3");
        this.head = this.neck3.getChild("head");
        this.mouth = this.head.getChild("mouth");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("severed_neck", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, -9.0f, 0.0f, 4.0f, 10.0f, 6.0f, CubeDeformation.NONE).texOffs(25, 22).addBox(-1.0f, -8.0f, 6.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition neck = partdefinition.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)22.0f, (float)-3.0f));
        PartDefinition neck1 = neck.addOrReplaceChild("neck1", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, -9.0f, 0.0f, 4.0f, 10.0f, 6.0f, CubeDeformation.NONE).texOffs(25, 22).addBox(-1.0f, -8.0f, 6.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-3.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition neck2 = neck1.addOrReplaceChild("neck2", CubeListBuilder.create().texOffs(0, 16).addBox(-2.01f, -10.0f, 0.0f, 4.0f, 10.0f, 6.0f, CubeDeformation.NONE).texOffs(25, 22).addBox(-1.0f, -10.0f, 6.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition neck3 = neck2.addOrReplaceChild("neck3", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, -10.0f, 0.0f, 4.0f, 10.0f, 6.0f, CubeDeformation.NONE).texOffs(25, 22).addBox(-1.0f, -9.0f, 6.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck3.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -8.0f, -4.0f, 6.0f, 8.0f, 8.0f, CubeDeformation.NONE).texOffs(33, 0).addBox(-3.0f, -4.0f, -10.0f, 6.0f, 3.0f, 6.0f, CubeDeformation.NONE).texOffs(38, 25).addBox(-2.5f, -3.25f, -9.5f, 5.0f, 3.0f, 4.0f, CubeDeformation.NONE).texOffs(25, 22).addBox(-1.0f, -8.0f, 4.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-9.0f, (float)3.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(33, 9).addBox(-3.0f, 0.0f, -6.0f, 6.0f, 1.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftLowerHorn = head.addOrReplaceChild("left_lower_horn", CubeListBuilder.create().texOffs(56, 27).addBox(-2.0f, -3.0f, -2.0f, 2.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)3.0f, (float)-6.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition leftMiddleHorn = leftLowerHorn.addOrReplaceChild("left_middle_horn", CubeListBuilder.create().texOffs(56, 22).addBox(-2.0f, -3.0f, -2.0f, 2.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.5236f, (float)0.0873f, (float)0.0f));
        PartDefinition leftUpperHorn = leftMiddleHorn.addOrReplaceChild("left_upper_horn", CubeListBuilder.create().texOffs(56, 17).addBox(-2.0f, -4.0f, -1.0f, 2.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)1.0472f, (float)0.0873f, (float)0.0f));
        PartDefinition rightLowerHorn = head.addOrReplaceChild("right_lower_horn", CubeListBuilder.create().texOffs(56, 27).addBox(0.0f, -3.0f, -2.0f, 2.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-3.0f, (float)-6.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition rightMiddleHorn = rightLowerHorn.addOrReplaceChild("right_middle_horn", CubeListBuilder.create().texOffs(56, 22).addBox(-1.0f, -3.0f, -2.0f, 2.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)-3.0f, (float)0.0f, (float)0.5236f, (float)-0.0873f, (float)0.0f));
        PartDefinition rightUpperHorn = rightMiddleHorn.addOrReplaceChild("right_upper_horn", CubeListBuilder.create().texOffs(56, 17).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)1.0472f, (float)-0.0873f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float yaw = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = yaw * 0.4f;
        this.neck1.yRot = yaw * 0.1f;
        this.neck2.yRot = yaw * 0.2f;
        this.neck3.yRot = yaw * 0.3f;
        this.severedNeck.xRot = this.neck1.xRot + this.neck.xRot;
        this.severedNeck.yRot = this.neck1.yRot + this.neck.yRot;
        this.severedNeck.zRot = this.neck1.zRot + this.neck.zRot;
        this.severedNeck.setPos(this.neck.x, this.neck.y + 2.0f, this.neck.z - 3.0f);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        float idleSwingCos = Mth.cos((float)(((float)(31 * entityIn.getId() + ((HydraHead)((Object)entityIn)).tickCount) + partialTick) * 0.19f));
        float swingPercent = entityIn.getAttackAnim(partialTick);
        float swing = Mth.cos((float)((swingPercent - 0.5f) * (float)Math.PI));
        this.mouth.xRot = 0.2618f + 0.45f * swing + 0.08f * idleSwingCos;
        this.neck1.xRot = 0.5236f + swing * 0.78f;
        this.neck2.xRot = -0.3491f + idleSwingCos * 0.04f;
        this.neck3.xRot = -0.1745f + idleSwingCos * 0.02f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, int color) {
        poseStack.translate(0.0, 0.0, 0.25);
        this.severedNeck.render(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
        if (!this.severed && !this.charred && this.spawnPercent > 0.0f) {
            float scale = this.spawnPercent;
            poseStack.translate(0.0f, 1.0f - scale, 0.0f);
            poseStack.scale(scale, scale, scale);
            this.neck.render(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
        }
    }

    public void setSpawnPercent(float spawnPercentIn) {
        this.spawnPercent = spawnPercentIn;
    }

    public void setSevered(boolean severedIn) {
        this.severed = severedIn;
    }

    public void setCharred(boolean charredIn) {
        this.charred = charredIn;
    }
}

